/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.interceptors;

import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.infinispan.commands.read.GetKeyValueCommand;
import org.infinispan.commands.write.EvictCommand;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.commands.write.PutMapCommand;
import org.infinispan.container.DataContainer;
import org.infinispan.context.InvocationContext;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.interceptors.base.JmxStatsCommandInterceptor;
import org.infinispan.jmx.annotations.MBean;
import org.infinispan.jmx.annotations.ManagedAttribute;
import org.infinispan.jmx.annotations.ManagedOperation;

@MBean(objectName="Statistics", description="General statistics such as timings, hit/miss ratio, etc.")
public class CacheMgmtInterceptor
extends JmxStatsCommandInterceptor {
    private AtomicLong hitTimes = new AtomicLong(0L);
    private AtomicLong missTimes = new AtomicLong(0L);
    private AtomicLong storeTimes = new AtomicLong(0L);
    private AtomicLong hits = new AtomicLong(0L);
    private AtomicLong misses = new AtomicLong(0L);
    private AtomicLong stores = new AtomicLong(0L);
    private AtomicLong evictions = new AtomicLong(0L);
    private AtomicLong start = new AtomicLong(System.currentTimeMillis());
    private AtomicLong reset = new AtomicLong(this.start.get());
    private DataContainer dataContainer;

    @Inject
    public void setDependencies(DataContainer dataContainer) {
        this.dataContainer = dataContainer;
    }

    @Override
    public Object visitEvictCommand(InvocationContext ctx, EvictCommand command) throws Throwable {
        Object returnValue = this.invokeNextInterceptor(ctx, command);
        this.evictions.incrementAndGet();
        return returnValue;
    }

    @Override
    public Object visitGetKeyValueCommand(InvocationContext ctx, GetKeyValueCommand command) throws Throwable {
        long t1 = System.currentTimeMillis();
        Object retval = this.invokeNextInterceptor(ctx, command);
        long t2 = System.currentTimeMillis();
        if (retval == null) {
            this.missTimes.getAndAdd(t2 - t1);
            this.misses.incrementAndGet();
        } else {
            this.hitTimes.getAndAdd(t2 - t1);
            this.hits.incrementAndGet();
        }
        return retval;
    }

    @Override
    public Object visitPutMapCommand(InvocationContext ctx, PutMapCommand command) throws Throwable {
        Map<Object, Object> data = command.getMap();
        long t1 = System.currentTimeMillis();
        Object retval = this.invokeNextInterceptor(ctx, command);
        long t2 = System.currentTimeMillis();
        if (data != null && data.size() > 0) {
            this.storeTimes.getAndAdd(t2 - t1);
            this.stores.getAndAdd(data.size());
        }
        return retval;
    }

    @Override
    public Object visitPutKeyValueCommand(InvocationContext ctx, PutKeyValueCommand command) throws Throwable {
        long t1 = System.currentTimeMillis();
        Object retval = this.invokeNextInterceptor(ctx, command);
        long t2 = System.currentTimeMillis();
        this.storeTimes.getAndAdd(t2 - t1);
        this.stores.incrementAndGet();
        return retval;
    }

    @ManagedAttribute(description="number of cache attribute hits")
    public long getHits() {
        return this.hits.get();
    }

    @ManagedAttribute(description="number of cache attribute misses")
    public long getMisses() {
        return this.misses.get();
    }

    @ManagedAttribute(description="number of cache attribute put operations")
    public long getStores() {
        return this.stores.get();
    }

    @ManagedAttribute(description="number of cache eviction operations")
    public long getEvictions() {
        return this.evictions.get();
    }

    @ManagedAttribute(description="hit/(hit+miss) ratio for the cache")
    public double getHitRatio() {
        double total = this.hits.get() + this.misses.get();
        if (total == 0.0) {
            return 0.0;
        }
        return (double)this.hits.get() / total;
    }

    @ManagedAttribute(description="read/writes ratio for the cache")
    public double getReadWriteRatio() {
        if (this.stores.get() == 0L) {
            return 0.0;
        }
        return (double)(this.hits.get() + this.misses.get()) / (double)this.stores.get();
    }

    @ManagedAttribute(description="average number of milliseconds for a read operation")
    public long getAverageReadTime() {
        long total = this.hits.get() + this.misses.get();
        if (total == 0L) {
            return 0L;
        }
        return (this.hitTimes.get() + this.missTimes.get()) / total;
    }

    @ManagedAttribute(description="average number of milliseconds for a write operation")
    public long getAverageWriteTime() {
        if (this.stores.get() == 0L) {
            return 0L;
        }
        return this.storeTimes.get() / this.stores.get();
    }

    @ManagedAttribute(description="number of entries in the cache")
    public int getNumberOfEntries() {
        return this.dataContainer.size();
    }

    @ManagedAttribute(description="seconds since cache started")
    public long getElapsedTime() {
        return (System.currentTimeMillis() - this.start.get()) / 1000L;
    }

    @ManagedAttribute(description="number of seconds since the cache statistics were last reset")
    public long getTimeSinceReset() {
        return (System.currentTimeMillis() - this.reset.get()) / 1000L;
    }

    @Override
    @ManagedOperation(description="Resets statistics gathered by this component")
    public void resetStatistics() {
        this.hits.set(0L);
        this.misses.set(0L);
        this.stores.set(0L);
        this.evictions.set(0L);
        this.hitTimes.set(0L);
        this.missTimes.set(0L);
        this.storeTimes.set(0L);
        this.reset.set(System.currentTimeMillis());
    }
}

