/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.factories;

import org.infinispan.config.ConfigurationException;
import org.infinispan.container.DataContainer;
import org.infinispan.container.FIFODataContainer;
import org.infinispan.container.LRUDataContainer;
import org.infinispan.container.SimpleDataContainer;
import org.infinispan.factories.AbstractNamedCacheComponentFactory;
import org.infinispan.factories.AutoInstantiableFactory;
import org.infinispan.factories.annotations.DefaultFactoryFor;

@DefaultFactoryFor(classes={DataContainer.class})
public class DataContainerFactory
extends AbstractNamedCacheComponentFactory
implements AutoInstantiableFactory {
    @Override
    public <T> T construct(Class<T> componentType) {
        switch (this.configuration.getEvictionStrategy()) {
            case NONE: {
                return (T)new SimpleDataContainer(this.configuration.getConcurrencyLevel());
            }
            case FIFO: {
                return (T)new FIFODataContainer(this.configuration.getConcurrencyLevel());
            }
            case LRU: {
                return (T)new LRUDataContainer(this.configuration.getConcurrencyLevel());
            }
        }
        throw new ConfigurationException("Unknown eviction strategy " + (Object)((Object)this.configuration.getEvictionStrategy()));
    }
}

