/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.factories;

import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.CacheException;
import org.infinispan.config.Configuration;
import org.infinispan.factories.AbstractNamedCacheComponentFactory;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.factories.annotations.DefaultFactoryFor;
import org.infinispan.factories.annotations.NonVolatile;

@DefaultFactoryFor(classes={Cache.class, AdvancedCache.class, Configuration.class, ComponentRegistry.class})
@NonVolatile
public class BootstrapFactory
extends AbstractNamedCacheComponentFactory {
    AdvancedCache advancedCache;

    public BootstrapFactory(AdvancedCache advancedCache, Configuration configuration, ComponentRegistry componentRegistry) {
        this.componentRegistry = componentRegistry;
        this.configuration = configuration;
        this.advancedCache = advancedCache;
    }

    @Override
    public <T> T construct(Class<T> componentType) {
        Object comp = null;
        if (componentType.isAssignableFrom(AdvancedCache.class)) {
            comp = this.advancedCache;
        } else if (componentType.isAssignableFrom(Configuration.class)) {
            comp = this.configuration;
        } else if (componentType.isAssignableFrom(ComponentRegistry.class)) {
            comp = this.componentRegistry;
        }
        if (comp == null) {
            throw new CacheException("Don't know how to handle type " + componentType);
        }
        try {
            return componentType.cast(comp);
        }
        catch (Exception e) {
            throw new CacheException("Problems casting bootstrap component " + comp.getClass() + " to type " + componentType, e);
        }
    }
}

