/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.distribution;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.infinispan.commands.tx.CommitCommand;
import org.infinispan.commands.tx.PrepareCommand;
import org.infinispan.commands.tx.RollbackCommand;
import org.infinispan.commands.write.WriteCommand;
import org.infinispan.distribution.TransactionLogger;
import org.infinispan.transaction.xa.GlobalTransaction;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class TransactionLoggerImpl
implements TransactionLogger {
    volatile boolean enabled;
    final ReadWriteLock loggingLock = new ReentrantReadWriteLock();
    final BlockingQueue<WriteCommand> commandQueue = new LinkedBlockingQueue<WriteCommand>();
    final Map<GlobalTransaction, PrepareCommand> uncommittedPrepares = new ConcurrentHashMap<GlobalTransaction, PrepareCommand>();
    private static final Log log = LogFactory.getLog(TransactionLoggerImpl.class);
    private static final boolean trace = log.isTraceEnabled();

    @Override
    public void enable() {
        this.enabled = true;
    }

    @Override
    public List<WriteCommand> drain() {
        LinkedList<WriteCommand> list = new LinkedList<WriteCommand>();
        this.commandQueue.drainTo(list);
        if (trace) {
            log.trace((Object)"Drained transaction log to {0}", list);
        }
        return list;
    }

    @Override
    public List<WriteCommand> drainAndLock() {
        this.loggingLock.writeLock().lock();
        return this.drain();
    }

    @Override
    public void unlockAndDisable() {
        this.enabled = false;
        this.loggingLock.writeLock().unlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean logIfNeeded(WriteCommand command) {
        block6: {
            if (this.enabled) {
                this.loggingLock.readLock().lock();
                try {
                    if (!this.enabled) break block6;
                    try {
                        this.commandQueue.put(command);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                    boolean bl = true;
                    return bl;
                }
                finally {
                    this.loggingLock.readLock().unlock();
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void logIfNeeded(PrepareCommand command) {
        if (this.enabled) {
            this.loggingLock.readLock().lock();
            try {
                if (this.enabled) {
                    if (trace) {
                        log.trace((Object)"Logging prepare for tx {0}", command.getGlobalTransaction());
                    }
                    this.uncommittedPrepares.put(command.getGlobalTransaction(), command);
                }
            }
            finally {
                this.loggingLock.readLock().unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void logIfNeeded(CommitCommand command) {
        if (this.enabled) {
            this.loggingLock.readLock().lock();
            try {
                if (this.enabled) {
                    if (trace) {
                        log.trace((Object)"Logging commit for tx {0}", command.getGlobalTransaction());
                    }
                    PrepareCommand prepareCommand = this.uncommittedPrepares.remove(command.getGlobalTransaction());
                }
            }
            finally {
                this.loggingLock.readLock().unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void logIfNeeded(RollbackCommand command) {
        if (this.enabled) {
            this.loggingLock.readLock().lock();
            try {
                if (this.enabled) {
                    if (trace) {
                        log.trace((Object)"Logging rollback for tx {0}", command.getGlobalTransaction());
                    }
                    this.uncommittedPrepares.remove(command.getGlobalTransaction());
                }
            }
            finally {
                this.loggingLock.readLock().unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean logIfNeeded(Collection<WriteCommand> commands) {
        if (this.enabled) {
            this.loggingLock.readLock().lock();
            try {
                if (this.enabled) {
                    for (WriteCommand command : commands) {
                        try {
                            this.commandQueue.put(command);
                        }
                        catch (InterruptedException e) {
                            Thread.currentThread().interrupt();
                        }
                    }
                    boolean bl = true;
                    return bl;
                }
            }
            finally {
                this.loggingLock.readLock().unlock();
            }
        }
        return false;
    }

    @Override
    public int size() {
        return this.enabled ? 0 : this.commandQueue.size();
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }
}

