/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.distribution;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.infinispan.commands.CommandsFactory;
import org.infinispan.commands.write.InvalidateCommand;
import org.infinispan.config.Configuration;
import org.infinispan.container.DataContainer;
import org.infinispan.distribution.ConsistentHash;
import org.infinispan.distribution.DistributionManagerImpl;
import org.infinispan.distribution.TransactionLogger;
import org.infinispan.remoting.rpc.RpcManager;
import org.infinispan.remoting.transport.Address;
import org.infinispan.util.concurrent.NotifyingFutureImpl;

public abstract class RehashTask
implements Callable<Void> {
    DistributionManagerImpl dmi;
    RpcManager rpcManager;
    Configuration configuration;
    TransactionLogger transactionLogger;
    CommandsFactory cf;
    DataContainer dataContainer;

    protected RehashTask(DistributionManagerImpl dmi, RpcManager rpcManager, Configuration configuration, TransactionLogger transactionLogger, CommandsFactory cf, DataContainer dataContainer) {
        this.dmi = dmi;
        this.rpcManager = rpcManager;
        this.configuration = configuration;
        this.transactionLogger = transactionLogger;
        this.cf = cf;
        this.dataContainer = dataContainer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Void call() throws Exception {
        this.dmi.rehashInProgress = true;
        try {
            this.performRehash();
            Void void_ = null;
            return void_;
        }
        finally {
            this.dmi.rehashInProgress = false;
        }
    }

    protected abstract void performRehash() throws Exception;

    protected Collection<Address> coordinator() {
        return Collections.singleton(this.rpcManager.getTransport().getCoordinator());
    }

    protected void invalidateInvalidHolders(ConsistentHash chOld, ConsistentHash chNew) throws ExecutionException, InterruptedException {
        HashMap<Address, HashSet<Object>> invalidations = new HashMap<Address, HashSet<Object>>();
        for (Object key : this.dataContainer.keySet()) {
            Collection<Address> collection = this.getInvalidHolders(key, chOld, chNew);
            for (Address a : collection) {
                HashSet<Object> s = (HashSet<Object>)invalidations.get(a);
                if (s == null) {
                    s = new HashSet<Object>();
                    invalidations.put(a, s);
                }
                s.add(key);
            }
        }
        HashSet<NotifyingFutureImpl> futures = new HashSet<NotifyingFutureImpl>();
        for (Map.Entry entry : invalidations.entrySet()) {
            InvalidateCommand ic = this.cf.buildInvalidateFromL1Command(((Set)entry.getValue()).toArray());
            NotifyingFutureImpl f = new NotifyingFutureImpl(null);
            this.rpcManager.invokeRemotelyInFuture(Collections.singletonList(entry.getKey()), ic, true, f);
            futures.add(f);
        }
        for (Future future : futures) {
            future.get();
        }
    }

    protected Collection<Address> getInvalidHolders(Object key, ConsistentHash chOld, ConsistentHash chNew) {
        List<Address> oldOwners = chOld.locate(key, this.configuration.getNumOwners());
        List<Address> newOwners = chNew.locate(key, this.configuration.getNumOwners());
        LinkedList<Address> toInvalidate = new LinkedList<Address>(oldOwners);
        toInvalidate.removeAll(newOwners);
        return toInvalidate;
    }
}

