/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.context.impl;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import org.infinispan.CacheException;
import org.infinispan.context.impl.AbstractInvocationContext;
import org.infinispan.context.impl.TxInvocationContext;
import org.infinispan.remoting.transport.Address;

public abstract class AbstractTxInvocationContext
extends AbstractInvocationContext
implements TxInvocationContext {
    protected Set<Address> txParticipants = null;

    @Override
    public boolean hasModifications() {
        return this.getModifications() != null && !this.getModifications().isEmpty();
    }

    @Override
    public Set<Address> getTransactionParticipants() {
        return this.txParticipants == null ? Collections.EMPTY_SET : this.txParticipants;
    }

    @Override
    public boolean isValidRunningTx() {
        return AbstractTxInvocationContext.isValid(this.getRunningTransaction());
    }

    @Override
    public void addTransactionParticipants(List<Address> addresses) {
        if (this.txParticipants == null) {
            this.txParticipants = new HashSet<Address>();
        }
        this.txParticipants.addAll(addresses);
    }

    public static boolean isValid(Transaction tx) {
        return AbstractTxInvocationContext.isActive(tx) || AbstractTxInvocationContext.isPreparing(tx);
    }

    public static boolean isActive(Transaction tx) {
        if (tx == null) {
            return false;
        }
        try {
            int status = tx.getStatus();
            return status == 0;
        }
        catch (SystemException e) {
            return false;
        }
    }

    public static boolean isPreparing(Transaction tx) {
        if (tx == null) {
            return false;
        }
        try {
            int status = tx.getStatus();
            return status == 7;
        }
        catch (SystemException e) {
            return false;
        }
    }

    public static void assertTransactionValid(TxInvocationContext ctx) {
        Transaction tx = ctx.getRunningTransaction();
        if (!AbstractTxInvocationContext.isValid(tx)) {
            try {
                throw new CacheException("Invalid transaction " + tx + ", status = " + (tx == null ? null : Integer.valueOf(tx.getStatus())));
            }
            catch (SystemException e) {
                throw new CacheException("Exception trying to analyse status of transaction " + tx, e);
            }
        }
    }

    @Override
    public AbstractTxInvocationContext clone() {
        AbstractTxInvocationContext dolly = (AbstractTxInvocationContext)super.clone();
        if (this.txParticipants != null) {
            dolly.txParticipants = new HashSet<Address>(this.txParticipants);
        }
        return dolly;
    }
}

