/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.container.entries;

import org.infinispan.CacheException;
import org.infinispan.container.DataContainer;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.container.entries.ReadCommittedEntry;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class RepeatableReadEntry
extends ReadCommittedEntry {
    private static final Log log = LogFactory.getLog(RepeatableReadEntry.class);

    public RepeatableReadEntry(Object key, Object value, long lifespan) {
        super(key, value, lifespan);
    }

    @Override
    public void copyForUpdate(DataContainer container, boolean writeSkewCheck) {
        InternalCacheEntry actualValue;
        if (this.isChanged()) {
            return;
        }
        this.setChanged();
        if (writeSkewCheck && (actualValue = container.get(this.key)) != null && actualValue != this.value) {
            String errormsg = "Detected write skew on key [" + this.getKey() + "].  Another process has changed the entry since we last read it!";
            if (log.isWarnEnabled()) {
                log.warn(errormsg + ".  Unable to copy entry for update.");
            }
            throw new CacheException(errormsg);
        }
        this.oldValue = this.value;
    }
}

