/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.container.entries;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.infinispan.container.entries.AbstractInternalCacheEntry;
import org.infinispan.container.entries.ExpiryHelper;
import org.infinispan.container.entries.ImmortalCacheEntry;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.container.entries.InternalCacheValue;
import org.infinispan.container.entries.MortalCacheValue;
import org.infinispan.container.entries.TransientMortalCacheEntry;
import org.infinispan.io.UnsignedNumeric;
import org.infinispan.marshall.Marshallable;

@Marshallable(externalizer=Externalizer.class, id=11)
public class MortalCacheEntry
extends AbstractInternalCacheEntry {
    private MortalCacheValue cacheValue;

    @Override
    public Object getValue() {
        return this.cacheValue.value;
    }

    @Override
    public Object setValue(Object value) {
        return this.cacheValue.setValue(value);
    }

    MortalCacheEntry(Object key, Object value, long lifespan) {
        this(key, value, lifespan, System.currentTimeMillis());
    }

    MortalCacheEntry(Object key, Object value, long lifespan, long created) {
        super(key);
        this.cacheValue = new MortalCacheValue(value, created, lifespan);
    }

    @Override
    public final boolean isExpired() {
        return ExpiryHelper.isExpiredMortal(this.cacheValue.lifespan, this.cacheValue.created);
    }

    @Override
    public final boolean canExpire() {
        return true;
    }

    @Override
    public InternalCacheEntry setMaxIdle(long maxIdle) {
        if (maxIdle > -1L) {
            TransientMortalCacheEntry tmce = new TransientMortalCacheEntry(this.key, this.cacheValue.value);
            tmce.setMaxIdle(maxIdle);
            return tmce;
        }
        return this;
    }

    @Override
    public InternalCacheEntry setLifespan(long lifespan) {
        if (lifespan < 0L) {
            return new ImmortalCacheEntry(this.key, this.cacheValue.value);
        }
        this.cacheValue.lifespan = lifespan;
        return this;
    }

    @Override
    public final long getCreated() {
        return this.cacheValue.created;
    }

    @Override
    public final long getLastUsed() {
        return -1L;
    }

    @Override
    public final long getLifespan() {
        return this.cacheValue.lifespan;
    }

    @Override
    public final long getMaxIdle() {
        return -1L;
    }

    @Override
    public final long getExpiryTime() {
        return this.cacheValue.lifespan > -1L ? this.cacheValue.created + this.cacheValue.lifespan : -1L;
    }

    @Override
    public final void touch() {
    }

    @Override
    public InternalCacheValue toInternalCacheValue() {
        return this.cacheValue;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MortalCacheEntry that = (MortalCacheEntry)o;
        if (this.key != null ? !this.key.equals(that.key) : that.key != null) {
            return false;
        }
        if (this.cacheValue.value != null ? !this.cacheValue.value.equals(that.cacheValue.value) : that.cacheValue.value != null) {
            return false;
        }
        if (this.cacheValue.created != that.cacheValue.created) {
            return false;
        }
        return this.cacheValue.lifespan == that.cacheValue.lifespan;
    }

    @Override
    public int hashCode() {
        int result = this.key != null ? this.key.hashCode() : 0;
        result = 31 * result + (this.cacheValue.value != null ? this.cacheValue.value.hashCode() : 0);
        result = 31 * result + (int)(this.cacheValue.created ^ this.cacheValue.created >>> 32);
        result = 31 * result + (int)(this.cacheValue.lifespan ^ this.cacheValue.lifespan >>> 32);
        return result;
    }

    @Override
    public MortalCacheEntry clone() {
        MortalCacheEntry clone = (MortalCacheEntry)super.clone();
        clone.cacheValue = this.cacheValue.clone();
        return clone;
    }

    public static class Externalizer
    implements org.infinispan.marshall.Externalizer {
        @Override
        public void writeObject(ObjectOutput output, Object subject) throws IOException {
            MortalCacheEntry ice = (MortalCacheEntry)subject;
            output.writeObject(ice.key);
            output.writeObject(((MortalCacheEntry)ice).cacheValue.value);
            UnsignedNumeric.writeUnsignedLong(output, ((MortalCacheEntry)ice).cacheValue.created);
            output.writeLong(((MortalCacheEntry)ice).cacheValue.lifespan);
        }

        @Override
        public Object readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            Object k = input.readObject();
            Object v = input.readObject();
            long created = UnsignedNumeric.readUnsignedLong(input);
            Long lifespan = input.readLong();
            return new MortalCacheEntry(k, v, lifespan, created);
        }
    }
}

