/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.container;

import org.infinispan.container.FIFODataContainer;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.container.entries.InternalEntryFactory;

public class LRUDataContainer
extends FIFODataContainer {
    public LRUDataContainer(int concurrencyLevel) {
        super(concurrencyLevel);
    }

    @Override
    public InternalCacheEntry get(Object k) {
        int h = this.hash(k.hashCode());
        FIFODataContainer.Segment s = this.segmentFor(h);
        FIFODataContainer.LinkedEntry le = s.get(k, h);
        InternalCacheEntry ice = null;
        if (le != null) {
            ice = le.e;
            if (this.isMarkedForRemoval(le)) {
                this.unlink(le);
            }
        }
        if (ice != null) {
            if (ice.isExpired()) {
                this.remove(k);
                ice = null;
            } else {
                ice.touch();
                this.updateLinks(le);
            }
        }
        return ice;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(Object k, Object v, long lifespan, long maxIdle) {
        int h = this.hash(k.hashCode());
        FIFODataContainer.Segment s = this.segmentFor(h);
        s.lock();
        boolean newEntry = false;
        try {
            InternalCacheEntry ice;
            FIFODataContainer.LinkedEntry le = s.get(k, h);
            InternalCacheEntry internalCacheEntry = ice = le == null ? null : le.e;
            if (ice == null) {
                newEntry = true;
                ice = InternalEntryFactory.create(k, v, lifespan, maxIdle);
                le = new FIFODataContainer.LinkedEntry(ice);
            } else {
                ice.setValue(v);
                le.e = ice = ice.setLifespan(lifespan).setMaxIdle(maxIdle);
            }
            s.locklessPut(k, h, le);
            if (newEntry) {
                this.linkAtEnd(le);
            } else {
                this.updateLinks(le);
            }
        }
        finally {
            s.unlock();
        }
    }

    protected final void updateLinks(FIFODataContainer.LinkedEntry le) {
        this.unlink(le);
        this.linkAtEnd(le);
    }
}

