/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.config;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.infinispan.CacheException;
import org.infinispan.config.AbstractConfigurationBean;
import org.infinispan.config.AbstractConfigurationBeanVisitor;
import org.infinispan.config.CacheLoaderManagerConfig;
import org.infinispan.config.Configuration;
import org.infinispan.util.ReflectionUtil;

public class OverrideConfigurationVisitor
extends AbstractConfigurationBeanVisitor {
    Configuration.AsyncType asyncType = null;
    CacheLoaderManagerConfig cacheLoaderManagerConfig = null;
    Configuration.ClusteringType clusteringType = null;
    Map<String, Configuration.BooleanAttributeType> bats = new HashMap<String, Configuration.BooleanAttributeType>();
    Configuration.CustomInterceptorsType customInterceptorsType = null;
    Configuration.DeadlockDetectionType deadlockDetectionType = null;
    Configuration.EvictionType evictionType = null;
    Configuration.ExpirationType expirationType = null;
    Configuration.HashType hashType = null;
    Configuration.L1Type l1Type = null;
    Configuration.LockingType lockingType = null;
    Configuration.StateRetrievalType stateRetrievalType = null;
    Configuration.SyncType syncType = null;
    Configuration.TransactionType transactionType = null;
    Configuration.UnsafeType unsafeType = null;

    public void override(OverrideConfigurationVisitor override) {
        Set<Map.Entry<String, Configuration.BooleanAttributeType>> entrySet = override.bats.entrySet();
        for (Map.Entry<String, Configuration.BooleanAttributeType> entry : entrySet) {
            Configuration.BooleanAttributeType attributeType = this.bats.get(entry.getKey());
            if (attributeType == null) continue;
            attributeType.enabled = entry.getValue().enabled;
        }
        this.overrideFields(this.cacheLoaderManagerConfig, override.cacheLoaderManagerConfig);
        this.overrideFields(this.asyncType, override.asyncType);
        this.overrideFields(this.clusteringType, override.clusteringType);
        this.overrideFields(this.deadlockDetectionType, override.deadlockDetectionType);
        this.overrideFields(this.evictionType, override.evictionType);
        this.overrideFields(this.expirationType, override.expirationType);
        this.overrideFields(this.hashType, override.hashType);
        this.overrideFields(this.l1Type, override.l1Type);
        this.overrideFields(this.lockingType, override.lockingType);
        this.overrideFields(this.stateRetrievalType, override.stateRetrievalType);
        this.overrideFields(this.syncType, override.syncType);
        this.overrideFields(this.transactionType, override.transactionType);
        this.overrideFields(this.unsafeType, override.unsafeType);
    }

    private void overrideFields(AbstractConfigurationBean bean, AbstractConfigurationBean overrides) {
        if (overrides != null && bean != null) {
            for (String overridenField : overrides.overriddenConfigurationElements) {
                try {
                    ReflectionUtil.setValue(bean, overridenField, ReflectionUtil.getValue(overrides, overridenField));
                }
                catch (Exception e1) {
                    throw new CacheException("Could not apply value for field " + overridenField + " from instance " + overrides + " on instance " + this, e1);
                }
            }
        }
    }

    @Override
    public void visitAsyncType(Configuration.AsyncType bean) {
        this.asyncType = bean;
    }

    @Override
    public void visitBooleanAttributeType(Configuration.BooleanAttributeType bat) {
        this.bats.put(bat.getFieldName(), bat);
    }

    @Override
    public void visitCacheLoaderManagerConfig(CacheLoaderManagerConfig bean) {
        this.cacheLoaderManagerConfig = bean;
    }

    @Override
    public void visitClusteringType(Configuration.ClusteringType bean) {
        this.clusteringType = bean;
    }

    @Override
    public void visitCustomInterceptorsType(Configuration.CustomInterceptorsType bean) {
        this.customInterceptorsType = bean;
    }

    @Override
    public void visitDeadlockDetectionType(Configuration.DeadlockDetectionType bean) {
        this.deadlockDetectionType = bean;
    }

    @Override
    public void visitEvictionType(Configuration.EvictionType bean) {
        this.evictionType = bean;
    }

    @Override
    public void visitExpirationType(Configuration.ExpirationType bean) {
        this.expirationType = bean;
    }

    @Override
    public void visitHashType(Configuration.HashType bean) {
        this.hashType = bean;
    }

    @Override
    public void visitL1Type(Configuration.L1Type bean) {
        this.l1Type = bean;
    }

    @Override
    public void visitLockingType(Configuration.LockingType bean) {
        this.lockingType = bean;
    }

    @Override
    public void visitStateRetrievalType(Configuration.StateRetrievalType bean) {
        this.stateRetrievalType = bean;
    }

    @Override
    public void visitSyncType(Configuration.SyncType bean) {
        this.syncType = bean;
    }

    @Override
    public void visitTransactionType(Configuration.TransactionType bean) {
        this.transactionType = bean;
    }

    @Override
    public void visitUnsafeType(Configuration.UnsafeType bean) {
        this.unsafeType = bean;
    }
}

