/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.config;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.HashSet;
import java.util.Locale;
import java.util.Properties;
import java.util.Set;
import org.infinispan.config.CloneableConfigurationComponent;
import org.infinispan.config.ConfigurationException;
import org.infinispan.config.Dynamic;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;
import org.infinispan.util.TypedProperties;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

@Scope(value=Scopes.NAMED_CACHE)
public abstract class AbstractConfigurationBean
implements CloneableConfigurationComponent {
    private static final long serialVersionUID = 4879873994727821938L;
    protected static final TypedProperties EMPTY_PROPERTIES = new TypedProperties();
    protected transient Log log = LogFactory.getLog(this.getClass());
    private boolean accessible;
    protected Set<String> overriddenConfigurationElements = new HashSet<String>();

    protected AbstractConfigurationBean() {
    }

    protected String uc(String s) {
        return s == null ? null : s.toUpperCase(Locale.ENGLISH);
    }

    protected TypedProperties toTypedProperties(Properties p) {
        return TypedProperties.toTypedProperties(p);
    }

    protected TypedProperties toTypedProperties(String s) {
        TypedProperties tp = new TypedProperties();
        if (s != null && s.trim().length() > 0) {
            ByteArrayInputStream stream = new ByteArrayInputStream(s.getBytes());
            try {
                tp.load(stream);
            }
            catch (IOException e) {
                throw new ConfigurationException("Unable to parse properties string " + s, e);
            }
        }
        return tp;
    }

    protected abstract boolean hasComponentStarted();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void testImmutability(String fieldName) {
        try {
            if (!this.accessible && this.hasComponentStarted() && !this.getClass().getDeclaredField(fieldName).isAnnotationPresent(Dynamic.class)) {
                throw new ConfigurationException("Attempted to modify a non-Dynamic configuration element [" + fieldName + "] after the component has started!");
            }
        }
        catch (NoSuchFieldException e) {
            this.log.warn("Field " + fieldName + " not found!!");
        }
        finally {
            this.accessible = false;
        }
        this.overriddenConfigurationElements.add(fieldName);
    }

    @Override
    public CloneableConfigurationComponent clone() throws CloneNotSupportedException {
        AbstractConfigurationBean c = (AbstractConfigurationBean)super.clone();
        return c;
    }
}

