/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands.control;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.infinispan.CacheException;
import org.infinispan.commands.remote.BaseRpcCommand;
import org.infinispan.config.Configuration;
import org.infinispan.container.DataContainer;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.container.entries.InternalCacheValue;
import org.infinispan.context.InvocationContext;
import org.infinispan.distribution.ConsistentHash;
import org.infinispan.distribution.DistributionManager;
import org.infinispan.loaders.CacheLoaderException;
import org.infinispan.loaders.CacheStore;
import org.infinispan.marshall.Marshallable;
import org.infinispan.marshall.exts.ReplicableCommandExternalizer;
import org.infinispan.remoting.transport.Address;
import org.infinispan.remoting.transport.Transport;

@Marshallable(externalizer=ReplicableCommandExternalizer.class, id=50)
public class RehashControlCommand
extends BaseRpcCommand {
    public static final int COMMAND_ID = 17;
    Type type;
    Address sender;
    Map<Object, InternalCacheValue> state;
    ConsistentHash consistentHash;
    DistributionManager distributionManager;
    Transport transport;
    Configuration configuration;
    DataContainer dataContainer;

    public RehashControlCommand(String cacheName, Type type, Address sender, Map<Object, InternalCacheValue> state, ConsistentHash consistentHash) {
        super(cacheName);
        this.type = type;
        this.sender = sender;
        this.state = state;
        this.consistentHash = consistentHash;
    }

    public RehashControlCommand() {
    }

    public RehashControlCommand(Transport transport) {
        this.transport = transport;
    }

    public void init(DistributionManager distributionManager, Configuration configuration, DataContainer dataContainer) {
        this.distributionManager = distributionManager;
        this.configuration = configuration;
        this.dataContainer = dataContainer;
    }

    @Override
    public Object perform(InvocationContext ctx) throws Throwable {
        switch (this.type) {
            case JOIN_REQ: {
                return this.distributionManager.requestPermissionToJoin(this.sender);
            }
            case JOIN_REHASH_START: {
                this.distributionManager.informRehashOnJoin(this.sender, true);
                return null;
            }
            case JOIN_REHASH_END: {
                this.distributionManager.informRehashOnJoin(this.sender, false);
                return null;
            }
            case JOIN_COMPLETE: {
                this.distributionManager.notifyJoinComplete(this.sender);
                return null;
            }
            case PULL_STATE: {
                return this.pullState();
            }
            case PUSH_STATE: {
                return this.pushState();
            }
        }
        throw new CacheException("Unknown rehash control command type " + (Object)((Object)this.type));
    }

    public Map<Object, InternalCacheValue> pullState() throws CacheLoaderException {
        Address self = this.transport.getAddress();
        ConsistentHash oldCH = this.distributionManager.getConsistentHash();
        int numCopies = this.configuration.getNumOwners();
        HashMap<Object, InternalCacheValue> state = new HashMap<Object, InternalCacheValue>();
        for (InternalCacheEntry ice : this.dataContainer) {
            Object k = ice.getKey();
            if (!this.shouldAddToMap(k, oldCH, numCopies, self)) continue;
            state.put(k, ice.toInternalCacheValue());
        }
        CacheStore cacheStore = this.distributionManager.getCacheStoreForRehashing();
        if (cacheStore != null) {
            for (InternalCacheEntry ice : cacheStore.loadAll()) {
                Object k = ice.getKey();
                if (state.containsKey(k) || !this.shouldAddToMap(k, oldCH, numCopies, self)) continue;
                state.put(k, ice.toInternalCacheValue());
            }
        }
        return state;
    }

    final boolean shouldAddToMap(Object k, ConsistentHash oldCH, int numCopies, Address self) {
        List<Address> newOwnerList;
        List<Address> oldOwnerList = oldCH.locate(k, numCopies);
        return oldOwnerList.size() > 0 && self.equals(oldOwnerList.get(0)) && (newOwnerList = this.consistentHash.locate(k, numCopies)).contains(this.sender);
    }

    public Object pushState() {
        this.distributionManager.applyReceivedState(this.state);
        return null;
    }

    @Override
    public byte getCommandId() {
        return 17;
    }

    @Override
    public Object[] getParameters() {
        return new Object[]{this.cacheName, (byte)this.type.ordinal(), this.sender, this.state, this.consistentHash};
    }

    @Override
    public void setParameters(int commandId, Object[] parameters) {
        int i = 0;
        this.cacheName = (String)parameters[i++];
        this.type = Type.values()[(Byte)parameters[i++]];
        this.sender = (Address)parameters[i++];
        this.state = (Map)parameters[i++];
        this.consistentHash = (ConsistentHash)parameters[i++];
    }

    public String toString() {
        return "RehashControlCommand{type=" + (Object)((Object)this.type) + ", sender=" + this.sender + ", state=" + this.state + ", consistentHash=" + this.consistentHash + '}';
    }

    public static enum Type {
        JOIN_REQ,
        JOIN_REHASH_START,
        JOIN_REHASH_END,
        JOIN_COMPLETE,
        JOIN_ABORT,
        PULL_STATE,
        PUSH_STATE;

    }
}

