/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands.control;

import java.util.Collection;
import org.infinispan.commands.Visitor;
import org.infinispan.commands.tx.AbstractTransactionBoundaryCommand;
import org.infinispan.commands.write.WriteCommand;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.impl.RemoteTxInvocationContext;
import org.infinispan.context.impl.TxInvocationContext;
import org.infinispan.marshall.Marshallable;
import org.infinispan.marshall.exts.ReplicableCommandExternalizer;
import org.infinispan.transaction.xa.GlobalTransaction;
import org.infinispan.transaction.xa.RemoteTransaction;

@Marshallable(externalizer=ReplicableCommandExternalizer.class, id=36)
public class LockControlCommand
extends AbstractTransactionBoundaryCommand {
    public static final int COMMAND_ID = 3;
    private Collection keys;
    private boolean implicit = false;

    public LockControlCommand() {
    }

    public LockControlCommand(Collection keys, String cacheName) {
        this(keys, cacheName, false);
    }

    public LockControlCommand(Collection keys, String cacheName, boolean implicit) {
        this.cacheName = cacheName;
        this.keys = keys;
        this.implicit = implicit;
    }

    public void attachGlobalTransaction(GlobalTransaction gtx) {
        this.globalTx = gtx;
    }

    public Collection getKeys() {
        return this.keys;
    }

    public boolean isImplicit() {
        return this.implicit;
    }

    public boolean isExplicit() {
        return !this.isImplicit();
    }

    @Override
    public Object acceptVisitor(InvocationContext ctx, Visitor visitor) throws Throwable {
        return visitor.visitLockControlCommand((TxInvocationContext)ctx, this);
    }

    @Override
    public Object perform(InvocationContext ignored) throws Throwable {
        boolean remoteTxinitiated;
        if (ignored != null) {
            throw new IllegalStateException("Expected null context!");
        }
        RemoteTxInvocationContext ctxt = this.icc.createRemoteTxInvocationContext();
        RemoteTransaction transaction = this.txTable.getRemoteTransaction(this.globalTx);
        boolean bl = remoteTxinitiated = transaction != null;
        if (!remoteTxinitiated) {
            transaction = this.txTable.createRemoteTransaction(this.globalTx, new WriteCommand[0]);
        }
        ctxt.setRemoteTransaction(transaction);
        return this.invoker.invoke(ctxt, this);
    }

    @Override
    public byte getCommandId() {
        return 3;
    }

    @Override
    public Object[] getParameters() {
        return new Object[]{this.globalTx, this.cacheName, this.keys};
    }

    @Override
    public void setParameters(int commandId, Object[] args) {
        if (commandId != 3) {
            throw new IllegalStateException("Unusupported command id:" + commandId);
        }
        this.globalTx = (GlobalTransaction)args[0];
        this.cacheName = (String)args[1];
        this.keys = (Collection)args[2];
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LockControlCommand that = (LockControlCommand)o;
        if (!super.equals(that)) {
            return false;
        }
        return ((Object)this.keys).equals(that.getKeys());
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        return 31 * result + (this.keys != null ? ((Object)this.keys).hashCode() : 0);
    }

    @Override
    public String toString() {
        return "LockControlCommand{gtx=" + this.globalTx + ", cacheName='" + this.cacheName + ", implicit='" + this.implicit + ", keys=" + this.keys + '}';
    }
}

