/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.atomic;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.LinkedList;
import java.util.List;
import org.infinispan.atomic.AtomicHashMap;
import org.infinispan.atomic.Delta;
import org.infinispan.atomic.DeltaAware;
import org.infinispan.atomic.Operation;
import org.infinispan.marshall.Marshallable;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

@Marshallable(externalizer=Externalizer.class, id=46)
public class AtomicHashMapDelta
implements Delta {
    private static final Log log = LogFactory.getLog(AtomicHashMapDelta.class);
    private static final boolean trace = log.isTraceEnabled();
    private List<Operation> changelog;

    @Override
    public DeltaAware merge(DeltaAware d) {
        AtomicHashMap other = d != null && d instanceof AtomicHashMap ? (AtomicHashMap)d : new AtomicHashMap();
        for (Operation o : this.changelog) {
            o.replay(other.delegate);
        }
        other.commit();
        return other;
    }

    public void addOperation(Operation o) {
        if (this.changelog == null) {
            this.changelog = new LinkedList<Operation>();
        }
        this.changelog.add(o);
    }

    public String toString() {
        return "AtomicHashMapDelta{changelog=" + this.changelog + '}';
    }

    public int getChangeLogSize() {
        return this.changelog == null ? 0 : this.changelog.size();
    }

    public static class Externalizer
    implements org.infinispan.marshall.Externalizer {
        @Override
        public void writeObject(ObjectOutput output, Object object) throws IOException {
            AtomicHashMapDelta delta = (AtomicHashMapDelta)object;
            if (trace) {
                log.trace("Serializing changelog " + delta.changelog);
            }
            output.writeObject(delta.changelog);
        }

        @Override
        public Object readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            AtomicHashMapDelta delta = new AtomicHashMapDelta();
            delta.changelog = (List)input.readObject();
            if (trace) {
                log.trace("Deserialized changelog " + delta.changelog);
            }
            return delta;
        }
    }
}

