/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.util.concurrent.locks.containers;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import org.infinispan.util.concurrent.locks.containers.LockContainer;

public abstract class AbstractPerEntryLockContainer
implements LockContainer {
    protected final ConcurrentMap<Object, Lock> locks;

    protected AbstractPerEntryLockContainer(int concurrencyLevel) {
        this.locks = new ConcurrentHashMap<Object, Lock>(16, 0.75f, concurrencyLevel);
    }

    protected abstract Lock newLock();

    public final Lock getLock(Object key) {
        Lock existingLock;
        Lock lock = (Lock)this.locks.get(key);
        if (lock == null) {
            lock = this.newLock();
        }
        if ((existingLock = this.locks.putIfAbsent(key, lock)) != null) {
            lock = existingLock;
        }
        return lock;
    }

    public int getNumLocksHeld() {
        return this.locks.size();
    }

    public int size() {
        return this.locks.size();
    }

    public boolean acquireLock(Object key, long timeout, TimeUnit unit) throws InterruptedException {
        Lock lock;
        while ((lock = this.getLock(key)).tryLock(timeout, unit)) {
            Lock existingLock = this.locks.putIfAbsent(key, lock);
            if (existingLock != null && existingLock != lock) {
                lock.unlock();
                continue;
            }
            return true;
        }
        return false;
    }

    public void releaseLock(Object key) {
        Lock l = (Lock)this.locks.remove(key);
        if (l != null) {
            l.unlock();
        }
    }
}

