/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.util.concurrent.locks;

import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import javax.transaction.TransactionManager;
import org.infinispan.config.Configuration;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.context.Flag;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.InvocationContextContainer;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.jmx.annotations.MBean;
import org.infinispan.jmx.annotations.ManagedAttribute;
import org.infinispan.util.ReversibleOrderedSet;
import org.infinispan.util.concurrent.locks.LockManager;
import org.infinispan.util.concurrent.locks.OwnableReentrantLock;
import org.infinispan.util.concurrent.locks.containers.LockContainer;
import org.infinispan.util.concurrent.locks.containers.OwnableReentrantPerEntryLockContainer;
import org.infinispan.util.concurrent.locks.containers.OwnableReentrantStripedLockContainer;
import org.infinispan.util.concurrent.locks.containers.ReentrantPerEntryLockContainer;
import org.infinispan.util.concurrent.locks.containers.ReentrantStripedLockContainer;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

@MBean(objectName="LockManager", description="Manager that handles MVCC locks for entries")
public class LockManagerImpl
implements LockManager {
    protected Configuration configuration;
    LockContainer lockContainer;
    private TransactionManager transactionManager;
    private InvocationContextContainer invocationContextContainer;
    private static final Log log = LogFactory.getLog(LockManagerImpl.class);
    private static final boolean trace = log.isTraceEnabled();

    @Inject
    public void injectDependencies(Configuration configuration, TransactionManager transactionManager, InvocationContextContainer invocationContextContainer) {
        this.configuration = configuration;
        this.transactionManager = transactionManager;
        this.invocationContextContainer = invocationContextContainer;
    }

    @Start
    public void startLockManager() {
        this.lockContainer = this.configuration.isUseLockStriping() ? (this.transactionManager == null ? new ReentrantStripedLockContainer(this.configuration.getConcurrencyLevel()) : new OwnableReentrantStripedLockContainer(this.configuration.getConcurrencyLevel(), this.invocationContextContainer)) : (this.transactionManager == null ? new ReentrantPerEntryLockContainer(this.configuration.getConcurrencyLevel()) : new OwnableReentrantPerEntryLockContainer(this.configuration.getConcurrencyLevel(), this.invocationContextContainer));
    }

    public boolean lockAndRecord(Object key, InvocationContext ctx) throws InterruptedException {
        long lockTimeout = this.getLockAcquisitionTimeout(ctx);
        if (trace) {
            log.trace((Object)"Attempting to lock {0} with acquisition timeout of {1} millis", key, lockTimeout);
        }
        return this.lockContainer.acquireLock(key, lockTimeout, TimeUnit.MILLISECONDS);
    }

    private long getLockAcquisitionTimeout(InvocationContext ctx) {
        return ctx.hasFlag(Flag.ZERO_LOCK_ACQUISITION_TIMEOUT) ? 0L : this.configuration.getLockAcquisitionTimeout();
    }

    public void unlock(Object key, Object owner) {
        if (trace) {
            log.trace("Attempting to unlock " + key);
        }
        this.lockContainer.releaseLock(key);
    }

    public void unlock(InvocationContext ctx) {
        ReversibleOrderedSet<Map.Entry<Object, CacheEntry>> entries = ctx.getLookedUpEntries().entrySet();
        if (!entries.isEmpty()) {
            Iterator<Map.Entry<Object, CacheEntry>> it = entries.reverseIterator();
            while (it.hasNext()) {
                Map.Entry<Object, CacheEntry> e = it.next();
                CacheEntry entry = e.getValue();
                if (!this.possiblyLocked(entry)) continue;
                Object k = e.getKey();
                if (trace) {
                    log.trace("Attempting to unlock " + k);
                }
                this.lockContainer.releaseLock(k);
            }
        }
    }

    public boolean ownsLock(Object key, Object owner) {
        return this.lockContainer.ownsLock(key, owner);
    }

    public boolean isLocked(Object key) {
        return this.lockContainer.isLocked(key);
    }

    public Object getOwner(Object key) {
        if (this.lockContainer.isLocked(key)) {
            Lock l = this.lockContainer.getLock(key);
            if (l instanceof OwnableReentrantLock) {
                return ((OwnableReentrantLock)l).getOwner();
            }
            return null;
        }
        return null;
    }

    public String printLockInfo() {
        return this.lockContainer.toString();
    }

    public final boolean possiblyLocked(CacheEntry entry) {
        return entry == null || entry.isChanged() || entry.isNull();
    }

    @ManagedAttribute(writable=false, description="The concurrency level that the MVCC Lock Manager has been configured with.")
    public int getConcurrencyLevel() {
        return this.configuration.getConcurrencyLevel();
    }

    @ManagedAttribute(writable=false, description="The number of exclusive locks that are held.")
    public int getNumberOfLocksHeld() {
        return this.lockContainer.getNumLocksHeld();
    }

    @ManagedAttribute(writable=false, description="The number of exclusive locks that are available.")
    public int getNumberOfLocksAvailable() {
        return this.lockContainer.size() - this.lockContainer.getNumLocksHeld();
    }
}

