/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.util;

import java.io.File;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.infinispan.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassFinder {
    public static String PATH = System.getProperty("java.class.path") + File.pathSeparator + System.getProperty("surefire.test.class.path");

    public static List<Class<?>> withAnnotationPresent(List<Class<?>> classes, Class<? extends Annotation> c) {
        ArrayList clazzes = new ArrayList();
        for (Class<?> clazz : classes) {
            if (!clazz.isAnnotationPresent(c)) continue;
            clazzes.add(clazz);
        }
        return clazzes;
    }

    public static List<Class<?>> isAssignableFrom(List<Class<?>> classes, Class<?> clazz) {
        ArrayList clazzes = new ArrayList();
        for (Class<?> c : classes) {
            if (!clazz.isAssignableFrom(c)) continue;
            clazzes.add(c);
        }
        return clazzes;
    }

    public static List<Class<?>> withAnnotationPresent(Class<? extends Annotation> ann) throws Exception {
        return ClassFinder.withAnnotationPresent(ClassFinder.infinispanClasses(), ann);
    }

    public static List<Class<?>> isAssignableFrom(Class<?> clazz) throws Exception {
        return ClassFinder.isAssignableFrom(ClassFinder.infinispanClasses(), clazz);
    }

    public static List<Class<?>> infinispanClasses() throws Exception {
        return ClassFinder.infinispanClasses(PATH);
    }

    public static List<Class<?>> infinispanClasses(String javaClassPath) throws Exception {
        ArrayList<File> files = new ArrayList<File>();
        for (String path : javaClassPath.split(File.pathSeparator)) {
            if ((!path.contains("infinispan") || !path.endsWith("jar")) && path.endsWith("jar")) continue;
            files.add(new File(path));
        }
        if (files.isEmpty()) {
            return Collections.emptyList();
        }
        if (files.size() == 1) {
            return ClassFinder.findClassesOnPath((File)files.get(0));
        }
        HashSet classFiles = new HashSet();
        for (File file : files) {
            classFiles.addAll(ClassFinder.findClassesOnPath(file));
        }
        return new ArrayList(classFiles);
    }

    private static List<Class<?>> findClassesOnPath(File path) throws Exception {
        ArrayList classes = new ArrayList();
        try {
            if (path.isDirectory()) {
                ArrayList<File> classFiles = new ArrayList<File>();
                ClassFinder.dir(classFiles, path);
                for (File cf : classFiles) {
                    Class claz = Util.loadClass(ClassFinder.toClassName(cf.getAbsolutePath().toString()));
                    classes.add(claz);
                }
            } else if (path.isFile() && path.getName().endsWith("jar") && path.canRead()) {
                JarFile jar = new JarFile(path);
                Enumeration<JarEntry> en = jar.entries();
                while (en.hasMoreElements()) {
                    JarEntry entry = en.nextElement();
                    if (!entry.getName().endsWith("class")) continue;
                    Class claz = Util.loadClass(ClassFinder.toClassName(entry.getName()));
                    classes.add(claz);
                }
            }
        }
        catch (NoClassDefFoundError e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        return classes;
    }

    private static void dir(List<File> files, File dir) {
        File[] entries;
        for (File entry : entries = dir.listFiles()) {
            if (entry.isDirectory()) {
                ClassFinder.dir(files, entry);
                continue;
            }
            if (!entry.getName().endsWith("class")) continue;
            files.add(entry);
        }
    }

    private static String toClassName(String fileName) {
        return fileName.substring(fileName.lastIndexOf("org"), fileName.length() - 6).replaceAll(File.separator, ".");
    }
}

