/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.marshall.jboss;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import org.infinispan.CacheException;
import org.infinispan.atomic.AtomicHashMap;
import org.infinispan.commands.LockControlCommand;
import org.infinispan.commands.RemoteCommandFactory;
import org.infinispan.commands.control.StateTransferControlCommand;
import org.infinispan.commands.read.GetKeyValueCommand;
import org.infinispan.commands.remote.ClusteredGetCommand;
import org.infinispan.commands.remote.MultipleRpcCommand;
import org.infinispan.commands.remote.SingleRpcCommand;
import org.infinispan.commands.tx.CommitCommand;
import org.infinispan.commands.tx.PrepareCommand;
import org.infinispan.commands.tx.RollbackCommand;
import org.infinispan.commands.write.ClearCommand;
import org.infinispan.commands.write.InvalidateCommand;
import org.infinispan.commands.write.InvalidateL1Command;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.commands.write.PutMapCommand;
import org.infinispan.commands.write.RemoveCommand;
import org.infinispan.commands.write.ReplaceCommand;
import org.infinispan.container.entries.ImmortalCacheEntry;
import org.infinispan.container.entries.ImmortalCacheValue;
import org.infinispan.container.entries.MortalCacheEntry;
import org.infinispan.container.entries.MortalCacheValue;
import org.infinispan.container.entries.TransientCacheEntry;
import org.infinispan.container.entries.TransientCacheValue;
import org.infinispan.container.entries.TransientMortalCacheEntry;
import org.infinispan.container.entries.TransientMortalCacheValue;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;
import org.infinispan.loaders.bucket.Bucket;
import org.infinispan.marshall.Externalizer;
import org.infinispan.marshall.MarshalledValue;
import org.infinispan.marshall.Marshaller;
import org.infinispan.marshall.exts.ArrayListExternalizer;
import org.infinispan.marshall.exts.BucketExternalizer;
import org.infinispan.marshall.exts.DeltaAwareExternalizer;
import org.infinispan.marshall.exts.ExceptionResponseExternalizer;
import org.infinispan.marshall.exts.ExtendedResponseExternalizer;
import org.infinispan.marshall.exts.GlobalTransactionExternalizer;
import org.infinispan.marshall.exts.ImmortalCacheEntryExternalizer;
import org.infinispan.marshall.exts.ImmortalCacheValueExternalizer;
import org.infinispan.marshall.exts.ImmutableMapExternalizer;
import org.infinispan.marshall.exts.JGroupsAddressExternalizer;
import org.infinispan.marshall.exts.LinkedListExternalizer;
import org.infinispan.marshall.exts.MapExternalizer;
import org.infinispan.marshall.exts.MarshalledValueExternalizer;
import org.infinispan.marshall.exts.MortalCacheEntryExternalizer;
import org.infinispan.marshall.exts.MortalCacheValueExternalizer;
import org.infinispan.marshall.exts.ReplicableCommandExternalizer;
import org.infinispan.marshall.exts.SetExternalizer;
import org.infinispan.marshall.exts.SingletonListExternalizer;
import org.infinispan.marshall.exts.SuccessfulResponseExternalizer;
import org.infinispan.marshall.exts.TransactionLogExternalizer;
import org.infinispan.marshall.exts.TransientCacheEntryExternalizer;
import org.infinispan.marshall.exts.TransientCacheValueExternalizer;
import org.infinispan.marshall.exts.TransientMortalCacheEntryExternalizer;
import org.infinispan.marshall.exts.TransientMortalCacheValueExternalizer;
import org.infinispan.remoting.responses.ExceptionResponse;
import org.infinispan.remoting.responses.ExtendedResponse;
import org.infinispan.remoting.responses.RequestIgnoredResponse;
import org.infinispan.remoting.responses.SuccessfulResponse;
import org.infinispan.remoting.responses.UnsuccessfulResponse;
import org.infinispan.remoting.transport.jgroups.JGroupsAddress;
import org.infinispan.transaction.xa.GlobalTransaction;
import org.infinispan.util.FastCopyHashMap;
import org.infinispan.util.Util;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.jboss.marshalling.ObjectTable;
import org.jboss.marshalling.Unmarshaller;

@Scope(value=Scopes.GLOBAL)
public class ConstantObjectTable
implements ObjectTable {
    private static final Log log = LogFactory.getLog(ConstantObjectTable.class);
    private static final int CAPACITY = 50;
    private static final Map<String, String> EXTERNALIZERS = new HashMap<String, String>(50);
    private final List<Object> objects = new ArrayList<Object>(50);
    private final Map<Class<?>, ExternalizerAdapter> writers = new IdentityHashMap(50);
    private byte index;

    public void init(RemoteCommandFactory cmdFactory, Marshaller ispnMarshaller) {
        byte by = this.index;
        this.index = (byte)(by + 1);
        ExternalizerAdapter adapter = new ExternalizerAdapter(by, new InstanceWriter(RequestIgnoredResponse.INSTANCE));
        this.objects.add(adapter);
        this.writers.put(RequestIgnoredResponse.class, adapter);
        byte by2 = this.index;
        this.index = (byte)(by2 + 1);
        adapter = new ExternalizerAdapter(by2, new InstanceWriter(UnsuccessfulResponse.INSTANCE));
        this.objects.add(adapter);
        this.writers.put(UnsuccessfulResponse.class, adapter);
        try {
            for (Map.Entry<String, String> entry : EXTERNALIZERS.entrySet()) {
                try {
                    Class typeClazz = Util.loadClass(entry.getKey());
                    Externalizer delegate = (Externalizer)Util.getInstance(entry.getValue());
                    if (delegate instanceof ReplicableCommandExternalizer) {
                        ((ReplicableCommandExternalizer)delegate).init(cmdFactory);
                    }
                    if (delegate instanceof MarshalledValueExternalizer) {
                        ((MarshalledValueExternalizer)delegate).init(ispnMarshaller);
                    }
                    byte by3 = this.index;
                    this.index = (byte)(by3 + 1);
                    ExternalizerAdapter rwrt = new ExternalizerAdapter(by3, delegate);
                    this.objects.add(rwrt);
                    this.writers.put(typeClazz, rwrt);
                }
                catch (ClassNotFoundException e) {
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)"Unable to load class (ignore if class belonging to a module not in use): {0}", e.getMessage());
                }
            }
        }
        catch (Exception e) {
            throw new CacheException("Unable to instantiate Externalizer class", e);
        }
    }

    public void stop() {
        this.writers.clear();
        this.objects.clear();
    }

    public ObjectTable.Writer getObjectWriter(Object o) throws IOException {
        return this.writers.get(o.getClass());
    }

    public Object readObject(Unmarshaller unmarshaller) throws IOException, ClassNotFoundException {
        ExternalizerAdapter adapter = (ExternalizerAdapter)this.objects.get(unmarshaller.readUnsignedByte());
        return adapter.readObject(unmarshaller);
    }

    static {
        EXTERNALIZERS.put(GlobalTransaction.class.getName(), GlobalTransactionExternalizer.class.getName());
        EXTERNALIZERS.put(JGroupsAddress.class.getName(), JGroupsAddressExternalizer.class.getName());
        EXTERNALIZERS.put(ArrayList.class.getName(), ArrayListExternalizer.class.getName());
        EXTERNALIZERS.put(LinkedList.class.getName(), LinkedListExternalizer.class.getName());
        EXTERNALIZERS.put(HashMap.class.getName(), MapExternalizer.class.getName());
        EXTERNALIZERS.put(TreeMap.class.getName(), MapExternalizer.class.getName());
        EXTERNALIZERS.put(HashSet.class.getName(), SetExternalizer.class.getName());
        EXTERNALIZERS.put(TreeSet.class.getName(), SetExternalizer.class.getName());
        EXTERNALIZERS.put("org.infinispan.util.Immutables$ImmutableMapWrapper", ImmutableMapExternalizer.class.getName());
        EXTERNALIZERS.put(MarshalledValue.class.getName(), MarshalledValueExternalizer.class.getName());
        EXTERNALIZERS.put(FastCopyHashMap.class.getName(), MapExternalizer.class.getName());
        EXTERNALIZERS.put("java.util.Collections$SingletonList", SingletonListExternalizer.class.getName());
        EXTERNALIZERS.put("org.infinispan.transaction.TransactionLog$LogEntry", TransactionLogExternalizer.class.getName());
        EXTERNALIZERS.put(ExtendedResponse.class.getName(), ExtendedResponseExternalizer.class.getName());
        EXTERNALIZERS.put(SuccessfulResponse.class.getName(), SuccessfulResponseExternalizer.class.getName());
        EXTERNALIZERS.put(ExceptionResponse.class.getName(), ExceptionResponseExternalizer.class.getName());
        EXTERNALIZERS.put(AtomicHashMap.class.getName(), DeltaAwareExternalizer.class.getName());
        EXTERNALIZERS.put(StateTransferControlCommand.class.getName(), ReplicableCommandExternalizer.class.getName());
        EXTERNALIZERS.put(ClusteredGetCommand.class.getName(), ReplicableCommandExternalizer.class.getName());
        EXTERNALIZERS.put(MultipleRpcCommand.class.getName(), ReplicableCommandExternalizer.class.getName());
        EXTERNALIZERS.put(SingleRpcCommand.class.getName(), ReplicableCommandExternalizer.class.getName());
        EXTERNALIZERS.put(GetKeyValueCommand.class.getName(), ReplicableCommandExternalizer.class.getName());
        EXTERNALIZERS.put(PutKeyValueCommand.class.getName(), ReplicableCommandExternalizer.class.getName());
        EXTERNALIZERS.put(RemoveCommand.class.getName(), ReplicableCommandExternalizer.class.getName());
        EXTERNALIZERS.put(InvalidateCommand.class.getName(), ReplicableCommandExternalizer.class.getName());
        EXTERNALIZERS.put(ReplaceCommand.class.getName(), ReplicableCommandExternalizer.class.getName());
        EXTERNALIZERS.put(ClearCommand.class.getName(), ReplicableCommandExternalizer.class.getName());
        EXTERNALIZERS.put(PutMapCommand.class.getName(), ReplicableCommandExternalizer.class.getName());
        EXTERNALIZERS.put(PrepareCommand.class.getName(), ReplicableCommandExternalizer.class.getName());
        EXTERNALIZERS.put(CommitCommand.class.getName(), ReplicableCommandExternalizer.class.getName());
        EXTERNALIZERS.put(RollbackCommand.class.getName(), ReplicableCommandExternalizer.class.getName());
        EXTERNALIZERS.put(InvalidateL1Command.class.getName(), ReplicableCommandExternalizer.class.getName());
        EXTERNALIZERS.put(LockControlCommand.class.getName(), ReplicableCommandExternalizer.class.getName());
        EXTERNALIZERS.put(ImmortalCacheEntry.class.getName(), ImmortalCacheEntryExternalizer.class.getName());
        EXTERNALIZERS.put(MortalCacheEntry.class.getName(), MortalCacheEntryExternalizer.class.getName());
        EXTERNALIZERS.put(TransientCacheEntry.class.getName(), TransientCacheEntryExternalizer.class.getName());
        EXTERNALIZERS.put(TransientMortalCacheEntry.class.getName(), TransientMortalCacheEntryExternalizer.class.getName());
        EXTERNALIZERS.put(ImmortalCacheValue.class.getName(), ImmortalCacheValueExternalizer.class.getName());
        EXTERNALIZERS.put(MortalCacheValue.class.getName(), MortalCacheValueExternalizer.class.getName());
        EXTERNALIZERS.put(TransientCacheValue.class.getName(), TransientCacheValueExternalizer.class.getName());
        EXTERNALIZERS.put(TransientMortalCacheValue.class.getName(), TransientMortalCacheValueExternalizer.class.getName());
        EXTERNALIZERS.put(Bucket.class.getName(), BucketExternalizer.class.getName());
        EXTERNALIZERS.put("org.infinispan.tree.NodeKey", "org.infinispan.tree.marshall.exts.NodeKeyExternalizer");
        EXTERNALIZERS.put("org.infinispan.tree.Fqn", "org.infinispan.tree.marshall.exts.FqnExternalizer");
    }

    class ExternalizerAdapter
    implements ObjectTable.Writer {
        final byte id;
        final Externalizer externalizer;

        ExternalizerAdapter(byte objectId, Externalizer externalizer) {
            this.id = objectId;
            this.externalizer = externalizer;
        }

        public Object readObject(Unmarshaller unmarshaller) throws IOException, ClassNotFoundException {
            return this.externalizer.readObject((ObjectInput)unmarshaller);
        }

        public void writeObject(org.jboss.marshalling.Marshaller marshaller, Object object) throws IOException {
            marshaller.write((int)this.id);
            this.externalizer.writeObject((ObjectOutput)marshaller, object);
        }
    }

    static class InstanceWriter
    implements Externalizer {
        private final Object singleton;

        InstanceWriter(Object singleton) {
            this.singleton = singleton;
        }

        public void writeObject(ObjectOutput output, Object object) throws IOException {
        }

        public Object readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            return this.singleton;
        }
    }
}

