/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.marshall.exts;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import net.jcip.annotations.Immutable;
import org.infinispan.container.entries.InternalEntryFactory;
import org.infinispan.container.entries.TransientCacheValue;
import org.infinispan.io.UnsignedNumeric;
import org.infinispan.marshall.Externalizer;

@Immutable
public class TransientCacheValueExternalizer
implements Externalizer {
    public void writeObject(ObjectOutput output, Object subject) throws IOException {
        TransientCacheValue icv = (TransientCacheValue)subject;
        output.writeObject(icv.getValue());
        UnsignedNumeric.writeUnsignedLong(output, icv.getLastUsed());
        output.writeLong(icv.getMaxIdle());
    }

    public Object readObject(ObjectInput input) throws IOException, ClassNotFoundException {
        Object v = input.readObject();
        long lastUsed = UnsignedNumeric.readUnsignedLong(input);
        Long maxIdle = input.readLong();
        return InternalEntryFactory.createValue(v, -1L, -1L, lastUsed, maxIdle);
    }
}

