/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.marshall.exts;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import net.jcip.annotations.Immutable;
import org.infinispan.container.entries.InternalEntryFactory;
import org.infinispan.container.entries.TransientCacheEntry;
import org.infinispan.io.UnsignedNumeric;
import org.infinispan.marshall.Externalizer;

@Immutable
public class TransientCacheEntryExternalizer
implements Externalizer {
    public void writeObject(ObjectOutput output, Object subject) throws IOException {
        TransientCacheEntry ice = (TransientCacheEntry)subject;
        output.writeObject(ice.getKey());
        output.writeObject(ice.getValue());
        UnsignedNumeric.writeUnsignedLong(output, ice.getLastUsed());
        output.writeLong(ice.getMaxIdle());
    }

    public Object readObject(ObjectInput input) throws IOException, ClassNotFoundException {
        Object k = input.readObject();
        Object v = input.readObject();
        long lastUsed = UnsignedNumeric.readUnsignedLong(input);
        Long maxIdle = input.readLong();
        return InternalEntryFactory.create(k, v, -1L, -1L, lastUsed, maxIdle);
    }
}

