/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.marshall.exts;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import net.jcip.annotations.Immutable;
import org.infinispan.commands.write.WriteCommand;
import org.infinispan.io.UnsignedNumeric;
import org.infinispan.marshall.Externalizer;
import org.infinispan.transaction.TransactionLog;
import org.infinispan.transaction.xa.GlobalTransaction;

@Immutable
public class TransactionLogExternalizer
implements Externalizer {
    public void writeObject(ObjectOutput output, Object subject) throws IOException {
        TransactionLog.LogEntry le = (TransactionLog.LogEntry)subject;
        output.writeObject(le.getTransaction());
        WriteCommand[] cmds = le.getModifications();
        UnsignedNumeric.writeUnsignedInt(output, cmds.length);
        for (WriteCommand c : cmds) {
            output.writeObject(c);
        }
    }

    public Object readObject(ObjectInput input) throws IOException, ClassNotFoundException {
        GlobalTransaction gtx = (GlobalTransaction)input.readObject();
        int numCommands = UnsignedNumeric.readUnsignedInt(input);
        WriteCommand[] cmds = new WriteCommand[numCommands];
        for (int i = 0; i < numCommands; ++i) {
            cmds[i] = (WriteCommand)input.readObject();
        }
        return new TransactionLog.LogEntry(gtx, cmds);
    }
}

