/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.marshall.exts;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.infinispan.container.entries.InternalEntryFactory;
import org.infinispan.container.entries.MortalCacheValue;
import org.infinispan.io.UnsignedNumeric;
import org.infinispan.marshall.Externalizer;

public class MortalCacheValueExternalizer
implements Externalizer {
    public void writeObject(ObjectOutput output, Object subject) throws IOException {
        MortalCacheValue icv = (MortalCacheValue)subject;
        output.writeObject(icv.getValue());
        UnsignedNumeric.writeUnsignedLong(output, icv.getCreated());
        output.writeLong(icv.getLifespan());
    }

    public Object readObject(ObjectInput input) throws IOException, ClassNotFoundException {
        Object v = input.readObject();
        long created = UnsignedNumeric.readUnsignedLong(input);
        Long lifespan = input.readLong();
        return InternalEntryFactory.createValue(v, created, lifespan, -1L, -1L);
    }
}

