/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.marshall.exts;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import net.jcip.annotations.Immutable;
import org.infinispan.container.entries.InternalEntryFactory;
import org.infinispan.container.entries.MortalCacheEntry;
import org.infinispan.io.UnsignedNumeric;
import org.infinispan.marshall.Externalizer;

@Immutable
public class MortalCacheEntryExternalizer
implements Externalizer {
    public void writeObject(ObjectOutput output, Object subject) throws IOException {
        MortalCacheEntry ice = (MortalCacheEntry)subject;
        output.writeObject(ice.getKey());
        output.writeObject(ice.getValue());
        UnsignedNumeric.writeUnsignedLong(output, ice.getCreated());
        output.writeLong(ice.getLifespan());
    }

    public Object readObject(ObjectInput input) throws IOException, ClassNotFoundException {
        Object k = input.readObject();
        Object v = input.readObject();
        long created = UnsignedNumeric.readUnsignedLong(input);
        Long lifespan = input.readLong();
        return InternalEntryFactory.create(k, v, created, lifespan, -1L, -1L);
    }
}

