/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.marshall.exts;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import net.jcip.annotations.Immutable;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.io.UnsignedNumeric;
import org.infinispan.loaders.bucket.Bucket;
import org.infinispan.marshall.Externalizer;

@Immutable
public class BucketExternalizer
implements Externalizer {
    public void writeObject(ObjectOutput output, Object subject) throws IOException {
        Bucket b = (Bucket)subject;
        UnsignedNumeric.writeUnsignedInt(output, b.getNumEntries());
        for (InternalCacheEntry se : b.getEntries().values()) {
            output.writeObject(se);
        }
    }

    public Object readObject(ObjectInput input) throws IOException, ClassNotFoundException {
        Bucket b = new Bucket();
        int numEntries = UnsignedNumeric.readUnsignedInt(input);
        for (int i = 0; i < numEntries; ++i) {
            b.addEntry((InternalCacheEntry)input.readObject());
        }
        return b;
    }
}

