/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.loaders;

import org.infinispan.config.ConfigurationAttribute;
import org.infinispan.loaders.AbstractCacheLoaderConfig;
import org.infinispan.loaders.CacheStoreConfig;
import org.infinispan.loaders.decorators.AsyncStoreConfig;
import org.infinispan.loaders.decorators.SingletonStoreConfig;
import org.infinispan.util.Util;

public class AbstractCacheStoreConfig
extends AbstractCacheLoaderConfig
implements CacheStoreConfig {
    private boolean ignoreModifications;
    private boolean fetchPersistentState;
    private boolean purgeOnStartup;
    private SingletonStoreConfig singletonStoreConfig = new SingletonStoreConfig();
    private AsyncStoreConfig asyncStoreConfig = new AsyncStoreConfig();
    private boolean purgeSynchronously = false;

    public boolean isPurgeSynchronously() {
        return this.purgeSynchronously;
    }

    public void setPurgeSynchronously(boolean purgeSynchronously) {
        this.testImmutability("purgeSynchronously");
        this.purgeSynchronously = purgeSynchronously;
    }

    public boolean isPurgeOnStartup() {
        return this.purgeOnStartup;
    }

    public boolean isFetchPersistentState() {
        return this.fetchPersistentState;
    }

    @ConfigurationAttribute(name="fetchPersistentState", containingElement="loader", description="If true, fetch persistent state on state transfer")
    public void setFetchPersistentState(boolean fetchPersistentState) {
        this.testImmutability("fetchPersistentState");
        this.fetchPersistentState = fetchPersistentState;
    }

    @ConfigurationAttribute(name="ignoreModifications", containingElement="loader", description="If true, any operation that modifies the cache store (remove, clear, store...etc) won't be applied to it")
    public void setIgnoreModifications(boolean ignoreModifications) {
        this.testImmutability("ignoreModifications");
        this.ignoreModifications = ignoreModifications;
    }

    public boolean isIgnoreModifications() {
        return this.ignoreModifications;
    }

    @ConfigurationAttribute(name="purgeOnStartup", containingElement="loader", description="If true, purge node state on startup")
    public void setPurgeOnStartup(boolean purgeOnStartup) {
        this.testImmutability("purgeOnStartup");
        this.purgeOnStartup = purgeOnStartup;
    }

    public SingletonStoreConfig getSingletonStoreConfig() {
        return this.singletonStoreConfig;
    }

    public void setSingletonStoreConfig(SingletonStoreConfig singletonStoreConfig) {
        this.testImmutability("singletonStoreConfig");
        this.singletonStoreConfig = singletonStoreConfig;
    }

    public AsyncStoreConfig getAsyncStoreConfig() {
        return this.asyncStoreConfig;
    }

    public void setAsyncStoreConfig(AsyncStoreConfig asyncStoreConfig) {
        this.testImmutability("asyncStoreConfig");
        this.asyncStoreConfig = asyncStoreConfig;
    }

    public boolean equals(Object obj) {
        if (super.equals(obj)) {
            if (!(obj instanceof AbstractCacheStoreConfig)) {
                return false;
            }
            AbstractCacheStoreConfig i = (AbstractCacheStoreConfig)obj;
            return this.equalsExcludingProperties(i);
        }
        return false;
    }

    protected boolean equalsExcludingProperties(Object obj) {
        AbstractCacheStoreConfig other = (AbstractCacheStoreConfig)obj;
        return Util.safeEquals(this.cacheLoaderClassName, other.cacheLoaderClassName) && this.ignoreModifications == other.ignoreModifications && this.fetchPersistentState == other.fetchPersistentState && Util.safeEquals(this.singletonStoreConfig, other.singletonStoreConfig) && Util.safeEquals(this.asyncStoreConfig, other.asyncStoreConfig) && Util.safeEquals(this.purgeSynchronously, other.purgeSynchronously);
    }

    public int hashCode() {
        return 31 * this.hashCodeExcludingProperties() + (this.properties == null ? 0 : this.properties.hashCode());
    }

    protected int hashCodeExcludingProperties() {
        int result = 17;
        result = 31 * result + (this.cacheLoaderClassName == null ? 0 : this.cacheLoaderClassName.hashCode());
        result = 31 * result + (this.ignoreModifications ? 0 : 1);
        result = 31 * result + (this.fetchPersistentState ? 0 : 1);
        result = 31 * result + (this.singletonStoreConfig == null ? 0 : this.singletonStoreConfig.hashCode());
        result = 31 * result + (this.asyncStoreConfig == null ? 0 : this.asyncStoreConfig.hashCode());
        result = 31 * result + (this.purgeOnStartup ? 0 : 1);
        return result;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{" + "className='" + this.cacheLoaderClassName + '\'' + ", ignoreModifications=" + this.ignoreModifications + ", fetchPersistentState=" + this.fetchPersistentState + ", properties=" + this.properties + ", purgeOnStartup=" + this.purgeOnStartup + "}," + ", SingletonStoreConfig{" + this.singletonStoreConfig + '}' + ", AsyncStoreConfig{" + this.asyncStoreConfig + '}' + ", purgeSynchronously{" + this.purgeSynchronously + '}';
    }

    public AbstractCacheStoreConfig clone() {
        AbstractCacheStoreConfig clone = null;
        clone = (AbstractCacheStoreConfig)super.clone();
        if (this.singletonStoreConfig != null) {
            clone.setSingletonStoreConfig(this.singletonStoreConfig.clone());
        }
        if (this.asyncStoreConfig != null) {
            clone.setAsyncStoreConfig(this.asyncStoreConfig.clone());
        }
        return clone;
    }
}

