/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.jmx;

import java.util.Set;
import javax.management.MBeanServer;
import org.infinispan.config.GlobalConfiguration;
import org.infinispan.factories.AbstractComponentRegistry;
import org.infinispan.factories.GlobalComponentRegistry;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.NonVolatile;
import org.infinispan.factories.annotations.Start;
import org.infinispan.factories.annotations.Stop;
import org.infinispan.jmx.CacheJmxRegistration;
import org.infinispan.jmx.ComponentsJmxRegistration;

@NonVolatile
public class CacheManagerJmxRegistration {
    public static final String GLOBAL_JMX_GROUP = "[global]";
    private GlobalComponentRegistry registry;
    private GlobalConfiguration globalConfiguration;
    private MBeanServer mBeanServer;

    @Inject
    public void init(GlobalComponentRegistry registry, GlobalConfiguration configuration) {
        this.registry = registry;
        this.globalConfiguration = configuration;
    }

    @Start(priority=20)
    public void start() {
        if (this.globalConfiguration.isExposeGlobalJmxStatistics()) {
            ComponentsJmxRegistration registrator = this.buildRegistrator();
            registrator.registerMBeans();
        }
    }

    public void setMBeanServer(MBeanServer mBeanServer) {
        this.mBeanServer = mBeanServer;
    }

    @Stop
    public void stop() {
        if (this.registry == null) {
            return;
        }
        if (this.globalConfiguration.isExposeGlobalJmxStatistics()) {
            ComponentsJmxRegistration componentsJmxRegistration = this.buildRegistrator();
            componentsJmxRegistration.unregisterMBeans();
        }
        this.registry = null;
    }

    private ComponentsJmxRegistration buildRegistrator() {
        Set<AbstractComponentRegistry.Component> components = this.registry.getRegisteredComponents();
        this.mBeanServer = CacheJmxRegistration.getMBeanServer(this.globalConfiguration);
        ComponentsJmxRegistration registrator = new ComponentsJmxRegistration(this.mBeanServer, components, GLOBAL_JMX_GROUP);
        CacheJmxRegistration.updateDomain(registrator, this.registry, this.mBeanServer);
        return registrator;
    }
}

