/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.interceptors;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import org.infinispan.commands.AbstractVisitor;
import org.infinispan.commands.CommandsFactory;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.commands.tx.PrepareCommand;
import org.infinispan.commands.write.ClearCommand;
import org.infinispan.commands.write.InvalidateCommand;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.commands.write.PutMapCommand;
import org.infinispan.commands.write.RemoveCommand;
import org.infinispan.commands.write.ReplaceCommand;
import org.infinispan.commands.write.WriteCommand;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.impl.TxInvocationContext;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.interceptors.base.BaseRpcInterceptor;
import org.infinispan.jmx.annotations.MBean;
import org.infinispan.jmx.annotations.ManagedAttribute;
import org.infinispan.jmx.annotations.ManagedOperation;
import org.infinispan.transaction.xa.GlobalTransaction;
import org.infinispan.util.concurrent.NotifyingFutureImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@MBean(objectName="Invalidation", description="Component responsible for invalidating entries on remote caches when entries are written to locally.")
public class InvalidationInterceptor
extends BaseRpcInterceptor {
    private final AtomicLong invalidations = new AtomicLong(0L);
    protected Map<GlobalTransaction, List<VisitableCommand>> txMods;
    private CommandsFactory commandsFactory;
    @ManagedAttribute(name="StatisticsEnabled", description="Enables or disables the gathering of statistics by this component", writable=true)
    private boolean statsEnabled;

    @Inject
    public void injectDependencies(CommandsFactory commandsFactory) {
        this.commandsFactory = commandsFactory;
    }

    @Start
    private void initTxMap() {
        this.setStatisticsEnabled(this.configuration.isExposeJmxStatistics());
    }

    @Override
    public Object visitPutKeyValueCommand(InvocationContext ctx, PutKeyValueCommand command) throws Throwable {
        return this.handleInvalidate(ctx, command, command.getKey());
    }

    @Override
    public Object visitReplaceCommand(InvocationContext ctx, ReplaceCommand command) throws Throwable {
        return this.handleInvalidate(ctx, command, command.getKey());
    }

    @Override
    public Object visitRemoveCommand(InvocationContext ctx, RemoveCommand command) throws Throwable {
        return this.handleInvalidate(ctx, command, command.getKey());
    }

    @Override
    public Object visitClearCommand(InvocationContext ctx, ClearCommand command) throws Throwable {
        Object retval = this.invokeNextInterceptor(ctx, command);
        if (ctx.isOriginLocal()) {
            this.rpcManager.broadcastRpcCommand(command, this.defaultSynchronous);
        }
        return retval;
    }

    @Override
    public Object visitPutMapCommand(InvocationContext ctx, PutMapCommand command) throws Throwable {
        Object[] keys = command.getMap() == null ? null : command.getMap().keySet().toArray();
        return this.handleInvalidate(ctx, command, keys);
    }

    @Override
    public Object visitPrepareCommand(TxInvocationContext ctx, PrepareCommand command) throws Throwable {
        Object retval = this.invokeNextInterceptor(ctx, command);
        if (this.trace) {
            this.log.trace("Entering InvalidationInterceptor's prepare phase");
        }
        if (ctx.hasModifications() && ctx.isOriginLocal()) {
            List<WriteCommand> mods = Arrays.asList(command.getModifications());
            Transaction runningTransaction = ctx.getRunningTransaction();
            if (runningTransaction == null) {
                throw new IllegalStateException("we must have an associated transaction");
            }
            this.broadcastInvalidateForPrepare(mods, runningTransaction, ctx);
        } else if (this.trace) {
            this.log.trace("Nothing to invalidate - no modifications in the transaction.");
        }
        return retval;
    }

    private Object handleInvalidate(InvocationContext ctx, WriteCommand command, Object ... keys) throws Throwable {
        Object retval = this.invokeNextInterceptor(ctx, command);
        if (command.isSuccessful() && !ctx.isInTxScope() && keys != null && keys.length != 0) {
            return this.invalidateAcrossCluster(this.isSynchronous(ctx), ctx, keys, ctx.isUseFutureReturnType(), retval);
        }
        return retval;
    }

    private void broadcastInvalidateForPrepare(List<WriteCommand> modifications, Transaction tx, InvocationContext ctx) throws Throwable {
        if (ctx.isInTxScope() && !this.isLocalModeForced(ctx)) {
            if (modifications == null || modifications.isEmpty()) {
                return;
            }
            InvalidationFilterVisitor filterVisitor = new InvalidationFilterVisitor(modifications.size());
            filterVisitor.visitCollection(null, modifications);
            if (filterVisitor.containsPutForExternalRead) {
                this.log.debug("Modification list contains a putForExternalRead operation.  Not invalidating.");
            } else {
                try {
                    this.invalidateAcrossCluster(this.defaultSynchronous, ctx, filterVisitor.result.toArray(), false, null);
                }
                catch (Throwable t) {
                    this.log.warn((Object)"Unable to broadcast evicts as a part of the prepare phase.  Rolling back.", t);
                    try {
                        tx.setRollbackOnly();
                    }
                    catch (SystemException se) {
                        throw new RuntimeException("setting tx rollback failed ", se);
                    }
                    if (t instanceof RuntimeException) {
                        throw (RuntimeException)t;
                    }
                    throw new RuntimeException("Unable to broadcast invalidation messages", t);
                }
            }
        }
    }

    protected Object invalidateAcrossCluster(boolean synchronous, InvocationContext ctx, Object[] keys, boolean useFuture, Object retvalForFuture) throws Throwable {
        if (!this.isLocalModeForced(ctx)) {
            this.incrementInvalidations();
            InvalidateCommand command = this.commandsFactory.buildInvalidateCommand(keys);
            if (this.log.isDebugEnabled()) {
                this.log.debug("Cache [" + this.rpcManager.getTransport().getAddress() + "] replicating " + command);
            }
            if (useFuture) {
                NotifyingFutureImpl future = new NotifyingFutureImpl(retvalForFuture);
                this.rpcManager.broadcastRpcCommandInFuture(command, future);
                return future;
            }
            this.rpcManager.broadcastRpcCommand(command, synchronous);
        }
        return retvalForFuture;
    }

    private void incrementInvalidations() {
        if (this.statsEnabled) {
            this.invalidations.incrementAndGet();
        }
    }

    @ManagedOperation(description="Resets statistics gathered by this component")
    public void resetStatistics() {
        this.invalidations.set(0L);
    }

    public boolean getStatisticsEnabled() {
        return this.statsEnabled;
    }

    public void setStatisticsEnabled(boolean enabled) {
        this.statsEnabled = enabled;
    }

    @ManagedAttribute(description="number of invalidations")
    public long getInvalidations() {
        return this.invalidations.get();
    }

    public static class InvalidationFilterVisitor
    extends AbstractVisitor {
        Set<Object> result;
        public boolean containsPutForExternalRead;

        public InvalidationFilterVisitor(int maxSetSize) {
            this.result = new HashSet<Object>(maxSetSize);
        }

        public Object visitPutKeyValueCommand(InvocationContext ctx, PutKeyValueCommand command) throws Throwable {
            this.result.add(command.getKey());
            return null;
        }

        public Object visitRemoveCommand(InvocationContext ctx, RemoveCommand command) throws Throwable {
            this.result.add(command.getKey());
            return null;
        }
    }
}

