/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.interceptors;

import org.infinispan.commands.LockControlCommand;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.commands.tx.CommitCommand;
import org.infinispan.commands.tx.PrepareCommand;
import org.infinispan.commands.tx.RollbackCommand;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.impl.TxInvocationContext;
import org.infinispan.interceptors.base.CommandInterceptor;

public class CallInterceptor
extends CommandInterceptor {
    public Object visitPrepareCommand(TxInvocationContext ctx, PrepareCommand command) throws Throwable {
        if (this.trace) {
            this.log.trace("Suppressing invocation of method handlePrepareCommand.");
        }
        return null;
    }

    public Object visitCommitCommand(TxInvocationContext ctx, CommitCommand command) throws Throwable {
        if (this.trace) {
            this.log.trace("Suppressing invocation of method handleCommitCommand.");
        }
        return null;
    }

    public Object visitRollbackCommand(TxInvocationContext ctx, RollbackCommand command) throws Throwable {
        if (this.trace) {
            this.log.trace("Suppressing invocation of method handleRollbackCommand.");
        }
        return null;
    }

    public Object visitLockControlCommand(TxInvocationContext ctx, LockControlCommand c) throws Throwable {
        if (this.trace) {
            this.log.trace("Suppressing invocation of method handleLockControlCommand.");
        }
        return null;
    }

    public final Object handleDefault(InvocationContext ctx, VisitableCommand command) throws Throwable {
        Object retval;
        if (this.trace) {
            this.log.trace("Executing command: " + command + ".");
        }
        try {
            retval = command.perform(ctx);
        }
        catch (Throwable t) {
            TxInvocationContext txContext;
            if (ctx.isInTxScope() && (txContext = (TxInvocationContext)ctx).isValidRunningTx()) {
                txContext.getRunningTransaction().setRollbackOnly();
            }
            throw t;
        }
        return retval;
    }
}

