/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.factories;

import java.util.List;
import org.infinispan.config.Configuration;
import org.infinispan.config.ConfigurationException;
import org.infinispan.config.CustomInterceptorConfig;
import org.infinispan.factories.AbstractNamedCacheComponentFactory;
import org.infinispan.factories.AutoInstantiableFactory;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.factories.annotations.DefaultFactoryFor;
import org.infinispan.interceptors.ActivationInterceptor;
import org.infinispan.interceptors.BatchingInterceptor;
import org.infinispan.interceptors.CacheLoaderInterceptor;
import org.infinispan.interceptors.CacheMgmtInterceptor;
import org.infinispan.interceptors.CacheStoreInterceptor;
import org.infinispan.interceptors.CallInterceptor;
import org.infinispan.interceptors.DistCacheStoreInterceptor;
import org.infinispan.interceptors.DistLockingInterceptor;
import org.infinispan.interceptors.DistTxInterceptor;
import org.infinispan.interceptors.DistributionInterceptor;
import org.infinispan.interceptors.ImplicitEagerLockingInterceptor;
import org.infinispan.interceptors.InterceptorChain;
import org.infinispan.interceptors.InvalidationInterceptor;
import org.infinispan.interceptors.InvocationContextInterceptor;
import org.infinispan.interceptors.LockingInterceptor;
import org.infinispan.interceptors.MarshalledValueInterceptor;
import org.infinispan.interceptors.NotificationInterceptor;
import org.infinispan.interceptors.PassivationInterceptor;
import org.infinispan.interceptors.ReplicationInterceptor;
import org.infinispan.interceptors.TxInterceptor;
import org.infinispan.interceptors.base.CommandInterceptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@DefaultFactoryFor(classes={InterceptorChain.class})
public class InterceptorChainFactory
extends AbstractNamedCacheComponentFactory
implements AutoInstantiableFactory {
    private CommandInterceptor createInterceptor(Class<? extends CommandInterceptor> clazz) throws IllegalAccessException, InstantiationException {
        CommandInterceptor chainedInterceptor = this.componentRegistry.getComponent(clazz);
        if (chainedInterceptor == null) {
            chainedInterceptor = clazz.newInstance();
            try {
                this.componentRegistry.registerComponent((Object)chainedInterceptor, clazz);
            }
            catch (RuntimeException e) {
                this.log.warn("Problems creating interceptor " + clazz);
                throw e;
            }
        } else {
            chainedInterceptor.setNext(null);
        }
        return chainedInterceptor;
    }

    public InterceptorChain buildInterceptorChain() throws IllegalAccessException, InstantiationException, ClassNotFoundException {
        boolean invocationBatching = this.configuration.isInvocationBatchingEnabled();
        CommandInterceptor first = invocationBatching ? this.createInterceptor(BatchingInterceptor.class) : this.createInterceptor(InvocationContextInterceptor.class);
        InterceptorChain interceptorChain = new InterceptorChain(first);
        this.componentRegistry.registerComponent((Object)interceptorChain, InterceptorChain.class);
        if (invocationBatching) {
            interceptorChain.appendIntereceptor(this.createInterceptor(InvocationContextInterceptor.class));
        }
        if (this.configuration.isExposeJmxStatistics()) {
            interceptorChain.appendIntereceptor(this.createInterceptor(CacheMgmtInterceptor.class));
        }
        if (this.configuration.getCacheMode().isDistributed()) {
            interceptorChain.appendIntereceptor(this.createInterceptor(DistTxInterceptor.class));
        } else {
            interceptorChain.appendIntereceptor(this.createInterceptor(TxInterceptor.class));
        }
        if (this.configuration.isUseEagerLocking()) {
            interceptorChain.appendIntereceptor(this.createInterceptor(ImplicitEagerLockingInterceptor.class));
        }
        if (this.configuration.isUseLazyDeserialization()) {
            interceptorChain.appendIntereceptor(this.createInterceptor(MarshalledValueInterceptor.class));
        }
        interceptorChain.appendIntereceptor(this.createInterceptor(NotificationInterceptor.class));
        switch (this.configuration.getCacheMode()) {
            case REPL_SYNC: 
            case REPL_ASYNC: {
                interceptorChain.appendIntereceptor(this.createInterceptor(ReplicationInterceptor.class));
                break;
            }
            case INVALIDATION_SYNC: 
            case INVALIDATION_ASYNC: {
                interceptorChain.appendIntereceptor(this.createInterceptor(InvalidationInterceptor.class));
                break;
            }
            case DIST_SYNC: 
            case DIST_ASYNC: {
                interceptorChain.appendIntereceptor(this.createInterceptor(DistributionInterceptor.class));
                break;
            }
        }
        if (this.configuration.isUsingCacheLoaders()) {
            if (this.configuration.getCacheLoaderManagerConfig().isPassivation()) {
                interceptorChain.appendIntereceptor(this.createInterceptor(ActivationInterceptor.class));
                interceptorChain.appendIntereceptor(this.createInterceptor(PassivationInterceptor.class));
            } else {
                interceptorChain.appendIntereceptor(this.createInterceptor(CacheLoaderInterceptor.class));
                switch (this.configuration.getCacheMode()) {
                    case DIST_SYNC: 
                    case DIST_ASYNC: {
                        interceptorChain.appendIntereceptor(this.createInterceptor(DistCacheStoreInterceptor.class));
                        break;
                    }
                    default: {
                        interceptorChain.appendIntereceptor(this.createInterceptor(CacheStoreInterceptor.class));
                    }
                }
            }
        }
        if (this.configuration.getCacheMode().isDistributed()) {
            interceptorChain.appendIntereceptor(this.createInterceptor(DistLockingInterceptor.class));
        } else {
            interceptorChain.appendIntereceptor(this.createInterceptor(LockingInterceptor.class));
        }
        CommandInterceptor callInterceptor = this.createInterceptor(CallInterceptor.class);
        interceptorChain.appendIntereceptor(callInterceptor);
        if (this.log.isTraceEnabled()) {
            this.log.trace("Finished building default interceptor chain.");
        }
        this.buildCustomInterceptors(interceptorChain, this.configuration.getCustomInterceptors());
        return interceptorChain;
    }

    private void buildCustomInterceptors(InterceptorChain interceptorChain, List<CustomInterceptorConfig> customInterceptors) {
        for (CustomInterceptorConfig config : customInterceptors) {
            List<CommandInterceptor> withClassName;
            if (interceptorChain.containsInstance(config.getInterceptor())) continue;
            if (config.isFirst()) {
                interceptorChain.addInterceptor(config.getInterceptor(), 0);
            }
            if (config.isLast()) {
                interceptorChain.appendIntereceptor(config.getInterceptor());
            }
            if (config.getIndex() >= 0) {
                interceptorChain.addInterceptor(config.getInterceptor(), config.getIndex());
            }
            if (config.getAfter() != null) {
                withClassName = interceptorChain.getInterceptorsWithClassName(config.getAfter());
                if (withClassName.isEmpty()) {
                    throw new ConfigurationException("Cannot add after class: " + config.getAfter() + " as no such iterceptor exists in the default chain");
                }
                interceptorChain.addInterceptorAfter(config.getInterceptor(), withClassName.get(0).getClass());
            }
            if (config.getBefore() == null) continue;
            withClassName = interceptorChain.getInterceptorsWithClassName(config.getBefore());
            if (withClassName.isEmpty()) {
                throw new ConfigurationException("Cannot add before class: " + config.getAfter() + " as no such iterceptor exists in the default chain");
            }
            interceptorChain.addInterceptorBefore(config.getInterceptor(), withClassName.get(0).getClass());
        }
    }

    @Override
    public <T> T construct(Class<T> componentType) {
        try {
            return componentType.cast(this.buildInterceptorChain());
        }
        catch (Exception e) {
            throw new ConfigurationException("Unable to build interceptor chain", e);
        }
    }

    public static InterceptorChainFactory getInstance(ComponentRegistry componentRegistry, Configuration configuration) {
        InterceptorChainFactory icf = new InterceptorChainFactory();
        icf.componentRegistry = componentRegistry;
        icf.configuration = configuration;
        return icf;
    }
}

