/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.container.entries;

import org.infinispan.container.entries.ImmortalCacheEntry;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.container.entries.InternalCacheValue;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class ImmortalCacheValue
implements InternalCacheValue,
Cloneable {
    private static final Log log = LogFactory.getLog(ImmortalCacheValue.class);
    Object value;

    ImmortalCacheValue(Object value) {
        this.value = value;
    }

    public InternalCacheEntry toInternalCacheEntry(Object key) {
        return new ImmortalCacheEntry(key, this.value);
    }

    public final Object setValue(Object value) {
        Object old = this.value;
        this.value = value;
        return old;
    }

    public Object getValue() {
        return this.value;
    }

    public boolean isExpired() {
        return false;
    }

    public boolean canExpire() {
        return false;
    }

    public long getCreated() {
        return -1L;
    }

    public long getLastUsed() {
        return -1L;
    }

    public long getLifespan() {
        return -1L;
    }

    public long getMaxIdle() {
        return -1L;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ImmortalCacheValue)) {
            return false;
        }
        ImmortalCacheValue that = (ImmortalCacheValue)o;
        return !(this.value != null ? !this.value.equals(that.value) : that.value != null);
    }

    public int hashCode() {
        return this.value != null ? this.value.hashCode() : 0;
    }

    public String toString() {
        return "ImmortalCacheValue{value=" + this.value + '}';
    }

    public ImmortalCacheValue clone() {
        try {
            return (ImmortalCacheValue)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException("Should never happen", e);
        }
    }
}

