/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.config.parsing.element;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.infinispan.config.ConfigurationException;
import org.infinispan.config.CustomInterceptorConfig;
import org.infinispan.config.parsing.XmlConfigHelper;
import org.infinispan.config.parsing.XmlParserBase;
import org.infinispan.interceptors.base.CommandInterceptor;
import org.infinispan.util.Util;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CustomInterceptorsElementParser
extends XmlParserBase {
    public List<CustomInterceptorConfig> parseCustomInterceptors(Element element) {
        NodeList interceptorNodes = element.getElementsByTagName("interceptor");
        ArrayList<CustomInterceptorConfig> interceptorConfigs = new ArrayList<CustomInterceptorConfig>(interceptorNodes.getLength());
        for (int i = 0; i < interceptorNodes.getLength(); ++i) {
            String indexStr;
            boolean first = false;
            boolean last = false;
            int index = -1;
            String after = null;
            String before = null;
            Element interceptorElement = (Element)interceptorNodes.item(i);
            String position = this.getAttributeValue(interceptorElement, "position");
            if (this.existsAttribute(position) && "first".equalsIgnoreCase(position)) {
                first = true;
            }
            if (this.existsAttribute(position) && "last".equalsIgnoreCase(position)) {
                last = true;
            }
            index = this.existsAttribute(indexStr = this.getAttributeValue(interceptorElement, "index")) ? this.getInt(indexStr) : -1;
            before = this.getAttributeValue(interceptorElement, "before");
            if (!this.existsAttribute(before)) {
                before = null;
            }
            if (!this.existsAttribute(after = this.getAttributeValue(interceptorElement, "after"))) {
                after = null;
            }
            CommandInterceptor interceptor = this.buildCommandInterceptor(interceptorElement);
            CustomInterceptorConfig customInterceptorConfig = new CustomInterceptorConfig(interceptor, first, last, index, after, before);
            interceptorConfigs.add(customInterceptorConfig);
        }
        return interceptorConfigs;
    }

    private CommandInterceptor buildCommandInterceptor(Element element) {
        CommandInterceptor result;
        String interceptorClass = this.getAttributeValue(element, "class");
        if (!this.existsAttribute(interceptorClass)) {
            throw new ConfigurationException("Interceptor class cannot be empty!");
        }
        try {
            result = (CommandInterceptor)Util.loadClass(interceptorClass).newInstance();
        }
        catch (Exception e) {
            throw new ConfigurationException("CommandInterceptor class is not properly loaded in classloader", e);
        }
        Properties p = XmlConfigHelper.extractProperties(element);
        if (p != null) {
            XmlConfigHelper.setValues(result, p, false, true);
        }
        return result;
    }
}

