/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.config.parsing;

import java.util.ArrayList;
import java.util.Properties;
import org.infinispan.config.AbstractConfigurationBean;
import org.infinispan.config.Configuration;
import org.infinispan.config.ConfigurationException;
import org.infinispan.config.CustomInterceptorConfig;
import org.infinispan.config.parsing.AutomatedXmlConfigurationParserImpl;
import org.infinispan.config.parsing.ConfigurationElementReader;
import org.infinispan.config.parsing.XmlConfigHelper;
import org.infinispan.interceptors.base.CommandInterceptor;
import org.infinispan.util.Util;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class CustomInterceptorConfigReader
implements ConfigurationElementReader {
    private AutomatedXmlConfigurationParserImpl parser;

    public void setParser(AutomatedXmlConfigurationParserImpl parser) {
        this.parser = parser;
    }

    public void process(Element e, AbstractConfigurationBean bean) {
        NodeList interceptorNodes = e.getElementsByTagName("interceptor");
        ArrayList<CustomInterceptorConfig> interceptorConfigs = new ArrayList<CustomInterceptorConfig>(interceptorNodes.getLength());
        for (int i = 0; i < interceptorNodes.getLength(); ++i) {
            String indexStr;
            boolean first = false;
            boolean last = false;
            int index = -1;
            String after = null;
            String before = null;
            Element interceptorElement = (Element)interceptorNodes.item(i);
            String position = this.parser.getAttributeValue(interceptorElement, "position");
            if (this.parser.existsAttribute(position) && "first".equalsIgnoreCase(position)) {
                first = true;
            }
            if (this.parser.existsAttribute(position) && "last".equalsIgnoreCase(position)) {
                last = true;
            }
            index = this.parser.existsAttribute(indexStr = this.parser.getAttributeValue(interceptorElement, "index")) ? this.parser.getInt(indexStr) : -1;
            before = this.parser.getAttributeValue(interceptorElement, "before");
            if (!this.parser.existsAttribute(before)) {
                before = null;
            }
            if (!this.parser.existsAttribute(after = this.parser.getAttributeValue(interceptorElement, "after"))) {
                after = null;
            }
            CommandInterceptor interceptor = this.buildCommandInterceptor(interceptorElement);
            CustomInterceptorConfig customInterceptorConfig = new CustomInterceptorConfig(interceptor, first, last, index, after, before);
            interceptorConfigs.add(customInterceptorConfig);
        }
        ((Configuration)bean).setCustomInterceptors(interceptorConfigs);
    }

    private CommandInterceptor buildCommandInterceptor(Element element) {
        CommandInterceptor result;
        String interceptorClass = this.parser.getAttributeValue(element, "class");
        if (!this.parser.existsAttribute(interceptorClass)) {
            throw new ConfigurationException("Interceptor class cannot be empty!");
        }
        try {
            result = (CommandInterceptor)Util.loadClass(interceptorClass).newInstance();
        }
        catch (Exception e) {
            throw new ConfigurationException("CommandInterceptor class is not properly loaded in classloader", e);
        }
        Properties p = XmlConfigHelper.extractProperties(element);
        if (p != null) {
            XmlConfigHelper.setValues(result, p, false, true);
        }
        return result;
    }
}

