/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.config.parsing;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.infinispan.util.FileLookup;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class ConfigFilesConvertor {
    private static final String JBOSS_CACHE3X = "JBossCache3x";
    private static final String EHCACHE_CACHE16X = "Ehcache16x";
    public static final String[] SUPPORTED_FORMATS = new String[]{"JBossCache3x", "Ehcache16x"};

    public void parse(InputStream is, OutputStream os, String xsltFile) throws Exception {
        InputStream xsltInStream = new FileLookup().lookupFile(xsltFile);
        if (xsltInStream == null) {
            throw new IllegalStateException("Cold not find xslt file! : " + xsltFile);
        }
        Document document = this.getInputDocument(is);
        Transformer transformer = this.getTransformer(xsltInStream);
        DOMSource source = new DOMSource(document);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        StreamResult result = new StreamResult(byteArrayOutputStream);
        transformer.transform(source, result);
        InputStream indentation = new FileLookup().lookupFile("xslt/indent.xslt");
        transformer = this.getTransformer(indentation);
        StreamResult finalResult = new StreamResult(os);
        StreamSource rawResult = new StreamSource(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
        transformer.transform(rawResult, finalResult);
        xsltInStream.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parse(String inputFile, OutputStream os, String xsltFile) throws Exception {
        InputStream stream = new FileLookup().lookupFile(inputFile);
        try {
            this.parse(stream, os, xsltFile);
        }
        finally {
            stream.close();
        }
    }

    private static void help() {
        System.out.println("Usage:");
        System.out.println("ConfigFilesConvertor [-source <the file to be transformed>] [-destination <where to store resulting XML>] [-type <the type of the source, possible values being: " + Arrays.asList(SUPPORTED_FORMATS) + " >]");
    }

    public static void main(String[] args) throws Exception {
        String sourceName = null;
        String destinationName = null;
        String type = null;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-source")) {
                sourceName = args[++i];
                continue;
            }
            if (args[i].equals("-destination")) {
                destinationName = args[++i];
                continue;
            }
            if (args[i].equals("-type")) {
                type = args[++i];
                continue;
            }
            ConfigFilesConvertor.help();
        }
        ConfigFilesConvertor.mustExist(sourceName, "source");
        ConfigFilesConvertor.mustExist(destinationName, "destination");
        ConfigFilesConvertor.mustExist(type, "type");
        List<String> stringList = Arrays.asList(SUPPORTED_FORMATS);
        if (!stringList.contains(type)) {
            System.err.println("Unsupported transformation type: " + type + ". Supported formats are: " + stringList);
        }
        if (type.equals(JBOSS_CACHE3X)) {
            ConfigFilesConvertor.transformFromJbossCache3x(sourceName, destinationName);
        } else if (type.equals(EHCACHE_CACHE16X)) {
            ConfigFilesConvertor.transformFromEhcache16x(sourceName, destinationName);
        }
        System.out.println("---");
        System.out.println("New configuration file [" + destinationName + "] successfully created.");
        System.out.println("---");
    }

    private static void mustExist(String sourceName, String what) {
        if (sourceName == null) {
            System.err.println("Missing '" + what + "', cannot proceed");
            ConfigFilesConvertor.help();
            System.exit(1);
        }
    }

    private static void transformFromJbossCache3x(String sourceName, String destinationName) throws Exception {
        File oldConfig = new File(sourceName);
        if (!oldConfig.exists()) {
            System.err.println("File specified as input ('" + sourceName + ") does not exist.");
            System.exit(1);
        }
        ConfigFilesConvertor convertor = new ConfigFilesConvertor();
        FileInputStream is = new FileInputStream(oldConfig);
        File destination = new File(destinationName);
        if (!destination.exists()) {
            destination.createNewFile();
        }
        FileOutputStream fos = new FileOutputStream(destinationName);
        convertor.parse(is, (OutputStream)fos, "xslt/jbc3x2infinispan4x.xslt");
        fos.close();
        is.close();
        File jgroupsConfigFile = new File("jgroupsConfig.xml");
        if (jgroupsConfigFile.exists()) {
            jgroupsConfigFile.delete();
        }
        jgroupsConfigFile.createNewFile();
        is = new FileInputStream(oldConfig);
        fos = new FileOutputStream(jgroupsConfigFile);
        convertor = new ConfigFilesConvertor();
        convertor.parse(is, (OutputStream)fos, "xslt/jgroupsFileGen.xslt");
        is.close();
        fos.close();
        if (jgroupsConfigFile.length() < 5L) {
            jgroupsConfigFile.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void transformFromEhcache16x(String sourceName, String destinationName) throws Exception {
        File oldConfig = new File(sourceName);
        if (!oldConfig.exists()) {
            System.err.println("File specified as input ('" + sourceName + ") does not exist.");
            System.exit(1);
        }
        ConfigFilesConvertor convertor = new ConfigFilesConvertor();
        FileInputStream is = new FileInputStream(oldConfig);
        File destination = new File(destinationName);
        if (!destination.exists()) {
            destination.createNewFile();
        }
        FileOutputStream fos = new FileOutputStream(destinationName);
        try {
            convertor.parse(is, (OutputStream)fos, "xslt/ehcache16x2infinispan4x.xslt");
        }
        finally {
            fos.close();
            is.close();
        }
    }

    private Transformer getTransformer(InputStream xsltInStream) throws TransformerConfigurationException {
        TransformerFactory tFactory = TransformerFactory.newInstance();
        StreamSource stylesource = new StreamSource(xsltInStream);
        return tFactory.newTransformer(stylesource);
    }

    private Document getInputDocument(InputStream is) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        return builder.parse(is);
    }
}

