/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.config.parsing;

import org.infinispan.config.AbstractConfigurationBean;
import org.infinispan.config.Configuration;
import org.infinispan.config.ConfigurationException;
import org.infinispan.config.parsing.AutomatedXmlConfigurationParserImpl;
import org.infinispan.config.parsing.ConfigurationElementReader;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ClusteringConfigReader
implements ConfigurationElementReader {
    private AutomatedXmlConfigurationParserImpl parser;

    public void setParser(AutomatedXmlConfigurationParserImpl parser) {
        this.parser = parser;
    }

    public void process(Element e, AbstractConfigurationBean bean) {
        boolean sync;
        if (e == null) {
            return;
        }
        Configuration config = (Configuration)bean;
        String mode = this.parser.getAttributeValue(e, "mode").toUpperCase();
        Configuration.CacheMode cacheMode = mode.startsWith("R") ? Configuration.CacheMode.REPL_SYNC : (mode.startsWith("I") ? Configuration.CacheMode.INVALIDATION_SYNC : Configuration.CacheMode.DIST_SYNC);
        Element asyncEl = this.parser.getSingleElementInCoreNS("async", e);
        Element syncEl = this.parser.getSingleElementInCoreNS("sync", e);
        if (syncEl != null && asyncEl != null) {
            throw new ConfigurationException("Cannot have sync and async elements within the same cluster element!");
        }
        boolean bl = sync = asyncEl == null;
        if (sync) {
            config.setCacheMode(cacheMode);
        } else {
            cacheMode = cacheMode.toAsync();
            config.setCacheMode(cacheMode);
        }
        NodeList nodeList = e.getChildNodes();
        int numChildren = nodeList.getLength();
        for (int i = 0; i < numChildren; ++i) {
            Node node = nodeList.item(i);
            if (!(node instanceof Element)) continue;
            Element childNode = (Element)node;
            this.parser.visitElement(childNode, bean);
        }
    }
}

