/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.config.parsing;

import java.lang.reflect.Method;
import java.util.Set;
import org.infinispan.config.AbstractConfigurationBean;
import org.infinispan.config.CacheLoaderManagerConfig;
import org.infinispan.config.Configuration;
import org.infinispan.config.ConfigurationException;
import org.infinispan.config.parsing.AutomatedXmlConfigurationParserImpl;
import org.infinispan.config.parsing.ConfigurationElementReader;
import org.infinispan.loaders.CacheLoader;
import org.infinispan.loaders.CacheLoaderConfig;
import org.infinispan.util.Util;
import org.w3c.dom.Element;

public class CacheLoaderManagerConfigReader
implements ConfigurationElementReader {
    private AutomatedXmlConfigurationParserImpl parser;

    public void setParser(AutomatedXmlConfigurationParserImpl parser) {
        this.parser = parser;
    }

    public void process(Element e, AbstractConfigurationBean bean) {
        CacheLoaderManagerConfig cBean = (CacheLoaderManagerConfig)this.parser.findAndInstantiateBean(e);
        for (Method m : cBean.getClass().getMethods()) {
            boolean setter;
            boolean bl = setter = m.getName().startsWith("set") && m.getParameterTypes().length == 1;
            if (!setter) continue;
            this.parser.reflectAndInvokeAttribute(cBean, m, e);
            this.parser.reflectAndInvokeProperties(cBean, m, e);
        }
        Set<Element> elements = this.parser.getAllElementsInCoreNS("loader", e);
        if (elements.isEmpty()) {
            throw new ConfigurationException("No loader elements found!");
        }
        for (Element element : elements) {
            CacheLoaderConfig clc;
            String clClass = this.parser.getAttributeValue(element, "class");
            if (!this.parser.existsAttribute(clClass)) {
                throw new ConfigurationException("Missing 'class'  attribute for cache loader configuration");
            }
            try {
                CacheLoader cl = (CacheLoader)Util.getInstance(clClass);
                clc = Util.getInstance(cl.getConfigurationClass());
            }
            catch (Exception ex) {
                throw new ConfigurationException("Unable to instantiate cache loader or configuration", ex);
            }
            clc.setCacheLoaderClassName(clClass);
            Element propertiesElement = this.parser.getSingleElementInCoreNS("properties", element);
            if (propertiesElement == null) {
                throw new ConfigurationException("loader " + clClass + " is missing properties element");
            }
            this.parser.visitElement(element, (AbstractConfigurationBean)((Object)clc));
            cBean.addCacheLoaderConfig(clc);
        }
        ((Configuration)bean).setCacheLoaderManagerConfig(cBean);
    }
}

