/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.config.parsing;

import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.infinispan.config.AbstractConfigurationBean;
import org.infinispan.config.Configuration;
import org.infinispan.config.ConfigurationAttribute;
import org.infinispan.config.ConfigurationElement;
import org.infinispan.config.ConfigurationElements;
import org.infinispan.config.ConfigurationException;
import org.infinispan.config.ConfigurationProperties;
import org.infinispan.config.ConfigurationProperty;
import org.infinispan.config.DuplicateCacheNameException;
import org.infinispan.config.GlobalConfiguration;
import org.infinispan.config.parsing.ConfigurationElementReader;
import org.infinispan.config.parsing.RootElementBuilder;
import org.infinispan.config.parsing.XmlConfigHelper;
import org.infinispan.config.parsing.XmlConfigurationParser;
import org.infinispan.config.parsing.XmlParserBase;
import org.infinispan.util.ClassFinder;
import org.infinispan.util.FileLookup;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AutomatedXmlConfigurationParserImpl
extends XmlParserBase
implements XmlConfigurationParser {
    private static List<Class<?>> CONFIG_BEANS = null;
    boolean initialized = false;
    Element rootElement;
    GlobalConfiguration gc;
    Map<String, Configuration> namedCaches;

    public AutomatedXmlConfigurationParserImpl() {
    }

    public AutomatedXmlConfigurationParserImpl(String fileName) throws IOException {
        this.initialize(fileName);
    }

    public AutomatedXmlConfigurationParserImpl(InputStream inputStream) throws IOException {
        this.initialize(inputStream);
    }

    @Override
    public void initialize(String fileName) throws IOException {
        if (fileName == null) {
            throw new NullPointerException("File name cannot be null!");
        }
        FileLookup fileLookup = new FileLookup();
        InputStream is = fileLookup.lookupFile(fileName);
        if (is == null) {
            throw new FileNotFoundException("File " + fileName + " could not be found, either on the classpath or on the file system!");
        }
        this.initialize(is);
    }

    @Override
    public void initialize(InputStream inputStream) throws IOException {
        if (inputStream == null) {
            throw new NullPointerException("Input stream cannot be null!");
        }
        this.initialized = true;
        this.rootElement = new RootElementBuilder().readRoot(inputStream);
    }

    @Override
    public Configuration parseDefaultConfiguration() throws ConfigurationException {
        this.assertInitialized();
        if (this.gc == null) {
            Element defaultElement = this.getSingleElementInCoreNS("default", this.rootElement);
            if (defaultElement == null) {
                return new Configuration();
            }
            defaultElement.normalize();
            AbstractConfigurationBean bean = this.findAndInstantiateBean(defaultElement);
            this.visitElement(defaultElement, bean);
            return (Configuration)bean;
        }
        return this.gc.getDefaultConfiguration();
    }

    @Override
    public Map<String, Configuration> parseNamedConfigurations() throws ConfigurationException {
        this.assertInitialized();
        if (this.namedCaches == null) {
            Set<Element> elements = this.getAllElementsInCoreNS("namedCache", this.rootElement);
            if (elements.isEmpty()) {
                return Collections.emptyMap();
            }
            this.namedCaches = new HashMap<String, Configuration>(elements.size(), 1.0f);
            for (Element e : elements) {
                String configurationName = this.getAttributeValue(e, "name");
                if (this.namedCaches.containsKey(configurationName)) {
                    this.namedCaches = null;
                    throw new DuplicateCacheNameException("Named cache " + configurationName + " is declared more than once!");
                }
                try {
                    AbstractConfigurationBean bean = this.findAndInstantiateBean(e);
                    this.visitElement(e, bean);
                    this.namedCaches.put(configurationName, (Configuration)bean);
                }
                catch (ConfigurationException ce) {
                    throw new ConfigurationException("Problems configuring named cache '" + configurationName + "'", ce);
                }
            }
        }
        return this.namedCaches;
    }

    @Override
    public GlobalConfiguration parseGlobalConfiguration() {
        this.assertInitialized();
        if (this.gc == null) {
            Configuration defaultConfiguration = this.parseDefaultConfiguration();
            Element globalElement = this.getSingleElementInCoreNS("global", this.rootElement);
            AbstractConfigurationBean bean = this.findAndInstantiateBean(globalElement);
            this.visitElement(globalElement, bean);
            this.gc = (GlobalConfiguration)bean;
            this.gc.setDefaultConfiguration(defaultConfiguration);
        }
        return this.gc;
    }

    AbstractConfigurationBean findAndInstantiateBean(List<Class<?>> b, Element e) throws ConfigurationException {
        String name = e.getTagName();
        String parentName = ((Element)e.getParentNode()).getTagName();
        if (parentName.equals("namedCache")) {
            parentName = "default";
        }
        for (Class<?> clazz : b) {
            ConfigurationElements elements = clazz.getAnnotation(ConfigurationElements.class);
            try {
                if (elements != null) {
                    for (ConfigurationElement ce : elements.elements()) {
                        if (!ce.name().equals(name) || !ce.parent().equals(parentName)) continue;
                        return (AbstractConfigurationBean)clazz.newInstance();
                    }
                    continue;
                }
                ConfigurationElement ce = clazz.getAnnotation(ConfigurationElement.class);
                if (ce == null || !ce.name().equals(name) || !ce.parent().equals(parentName)) continue;
                return (AbstractConfigurationBean)clazz.newInstance();
            }
            catch (Exception e1) {
                throw new ConfigurationException("Could not instantiate class " + clazz, e1);
            }
        }
        return null;
    }

    AbstractConfigurationBean findAndInstantiateBean(Element e) throws ConfigurationException {
        return this.findAndInstantiateBean(CONFIG_BEANS, e);
    }

    private ConfigurationElement findConfigurationElement(Element e, Class<?> bean) {
        ConfigurationElement result = null;
        ConfigurationElement[] ces = null;
        ConfigurationElements configurationElements = bean.getAnnotation(ConfigurationElements.class);
        ConfigurationElement configurationElement = bean.getAnnotation(ConfigurationElement.class);
        String parentName = ((Element)e.getParentNode()).getTagName();
        if (parentName.equals("namedCache")) {
            parentName = "default";
        }
        if (configurationElement != null) {
            ces = new ConfigurationElement[]{configurationElement};
        }
        if (configurationElements != null) {
            ces = configurationElements.elements();
        }
        if (ces != null) {
            for (ConfigurationElement el : ces) {
                if (!el.name().equals(e.getNodeName()) || !el.parent().equals(parentName)) continue;
                result = el;
                break;
            }
        }
        return result;
    }

    private Class<? extends ConfigurationElementReader> customReader(Element e, Class<?> bean) {
        Class<? extends ConfigurationElementReader> clazz = null;
        ConfigurationElement ce = this.findConfigurationElement(e, bean);
        if (ce == null) {
            Class<?> beanClass;
            Iterator<Class<?>> i$ = CONFIG_BEANS.iterator();
            while (i$.hasNext() && (ce = this.findConfigurationElement(e, beanClass = i$.next())) == null) {
            }
        }
        if (ce != null && !ce.customReader().equals(ConfigurationElementReader.class)) {
            clazz = ce.customReader();
        }
        return clazz;
    }

    void visitElement(Element e, AbstractConfigurationBean bean) throws ConfigurationException {
        Class<? extends ConfigurationElementReader> readerClass = this.customReader(e, bean.getClass());
        if (readerClass != null) {
            ConfigurationElementReader reader = null;
            try {
                reader = readerClass.newInstance();
                reader.setParser(this);
                reader.process(e, bean);
            }
            catch (Exception e1) {
                throw new ConfigurationException("Exception while using custom reader " + readerClass + " for element " + e.getNodeName(), e1);
            }
        } else {
            this.visitElementDefault(e, bean);
        }
    }

    void visitElementDefault(Element e, AbstractConfigurationBean bean) {
        for (Method m : bean.getClass().getMethods()) {
            boolean setter;
            boolean bl = setter = m.getName().startsWith("set") && m.getParameterTypes().length == 1;
            if (!setter) continue;
            this.reflectAndInvokeAttribute(bean, m, e);
            this.reflectAndInvokeProperties(bean, m, e);
        }
        NodeList nodeList = e.getChildNodes();
        int numChildren = nodeList.getLength();
        for (int i = 0; i < numChildren; ++i) {
            Node child = nodeList.item(i);
            if (!(child instanceof Element)) continue;
            this.visitElement((Element)child, bean);
        }
    }

    void reflectAndInvokeAttribute(AbstractConfigurationBean bean, Method m, Element node) {
        Class<?> parameterType = m.getParameterTypes()[0];
        ConfigurationAttribute a = m.getAnnotation(ConfigurationAttribute.class);
        boolean matchedAttributeToSetter = a != null && a.containingElement().equals(node.getNodeName());
        boolean isConfigBean = AbstractConfigurationBean.class.isAssignableFrom(parameterType);
        if (matchedAttributeToSetter) {
            String attValue = this.getAttributeValue(node, a.name());
            Object methodAttributeValue = null;
            if (attValue != null && attValue.length() > 0) {
                PropertyEditor editor = PropertyEditorManager.findEditor(parameterType);
                if (editor == null) {
                    throw new ConfigurationException("Could not find property editor, type=" + parameterType + ",method=" + m + ",attribute=" + a.name());
                }
                editor.setAsText(attValue);
                methodAttributeValue = editor.getValue();
            } else if (a.defaultValue().length() > 0) {
                methodAttributeValue = a.defaultValue();
            }
            if (methodAttributeValue != null) {
                try {
                    m.invoke((Object)bean, methodAttributeValue);
                }
                catch (Exception ae) {
                    throw new ConfigurationException("Illegal attribute value " + attValue + ",type=" + parameterType + ",method=" + m + ",attribute=" + a.name(), ae);
                }
            }
        } else if (isConfigBean) {
            boolean foundMatchingChild;
            AbstractConfigurationBean childBean = this.findAndInstantiateBean(node);
            boolean bl = foundMatchingChild = childBean != null && !bean.getClass().equals(childBean.getClass()) && parameterType.isInstance(childBean);
            if (foundMatchingChild) {
                this.visitElement(node, childBean);
                try {
                    m.invoke((Object)bean, childBean);
                }
                catch (Exception ae) {
                    throw new ConfigurationException("Illegal bean value " + childBean + ",type=" + parameterType + ", method=" + m, ae);
                }
            }
        }
    }

    boolean reflectAndInvokeProperties(AbstractConfigurationBean bean, Method m, Element node) {
        String parentElement;
        boolean matchedPropertyToSetter;
        Class<?> parameterType = m.getParameterTypes()[0];
        ConfigurationProperty[] cprops = null;
        ConfigurationProperties cp = m.getAnnotation(ConfigurationProperties.class);
        if (cp != null) {
            cprops = cp.elements();
        } else {
            ConfigurationProperty p = null;
            p = m.getAnnotation(ConfigurationProperty.class);
            if (p != null) {
                cprops = new ConfigurationProperty[]{p};
            }
        }
        boolean bl = matchedPropertyToSetter = cprops != null && cprops.length > 0;
        if (matchedPropertyToSetter && (parentElement = cprops[0].parentElement()).equals(node.getParentNode().getNodeName()) && node.getNodeName().equals("property")) {
            Properties props = XmlConfigHelper.extractProperties((Element)node.getParentNode());
            if (Properties.class.isAssignableFrom(parameterType)) {
                try {
                    m.invoke((Object)bean, props);
                }
                catch (Exception ae) {
                    throw new ConfigurationException("Illegal props " + props + ",type=" + parameterType + ", method=" + m, ae);
                }
            } else {
                XmlConfigHelper.setValues(bean, props, false, true);
            }
            return true;
        }
        return false;
    }

    private void assertInitialized() {
        if (!this.initialized) {
            throw new ConfigurationException("Parser not initialized.  Please invoke initialize() first, or use a constructor that initializes the parser.");
        }
    }

    static {
        String path = ClassFinder.PATH;
        try {
            CONFIG_BEANS = ClassFinder.isAssignableFrom(ClassFinder.infinispanClasses(), AbstractConfigurationBean.class);
        }
        catch (Exception e) {
            throw new ConfigurationException("Exception while searching for Infinispan configuration beans, path is " + path, e);
        }
        if (CONFIG_BEANS == null || CONFIG_BEANS.isEmpty()) {
            throw new ConfigurationException("Could not find Infinispan configuration beans, path is " + path);
        }
    }
}

