/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.config;

import net.jcip.annotations.Immutable;
import org.infinispan.config.AbstractNamedCacheConfigurationBean;
import org.infinispan.config.ConfigurationAttribute;
import org.infinispan.config.ConfigurationElement;
import org.infinispan.interceptors.base.CommandInterceptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Immutable
@ConfigurationElement(name="interceptor", parent="customInterceptors")
public class CustomInterceptorConfig
extends AbstractNamedCacheConfigurationBean {
    private CommandInterceptor interceptor;
    private boolean isFirst;
    private boolean isLast;
    private int index = -1;
    private String after;
    private String before;

    public CustomInterceptorConfig(CommandInterceptor interceptor, boolean first, boolean last, int index, String after, String before) {
        this.interceptor = interceptor;
        this.isFirst = first;
        this.isLast = last;
        this.index = index;
        this.after = after;
        this.before = before;
    }

    public CustomInterceptorConfig(CommandInterceptor interceptor, boolean first, boolean last, int index, Class<? extends CommandInterceptor> after, Class<? extends CommandInterceptor> before) {
        this.interceptor = interceptor;
        this.isFirst = first;
        this.isLast = last;
        this.index = index;
        this.after = after == null ? null : after.getName();
        this.before = before == null ? null : before.getName();
    }

    public CustomInterceptorConfig(CommandInterceptor interceptor) {
        this.interceptor = interceptor;
    }

    public void setFirst(boolean first) {
        this.testImmutability("first");
        this.isFirst = first;
    }

    public void setLast(boolean last) {
        this.testImmutability("last");
        this.isLast = last;
    }

    @ConfigurationAttribute(name="index", containingElement="interceptor")
    public void setIndex(int index) {
        this.testImmutability("index");
        this.index = index;
    }

    @ConfigurationAttribute(name="after", containingElement="interceptor")
    public void setAfterInterceptor(String afterClass) {
        this.testImmutability("after");
        this.after = afterClass;
    }

    public void setAfterInterceptor(Class<? extends CommandInterceptor> interceptorClass) {
        this.setAfterInterceptor(interceptorClass.getName());
    }

    @ConfigurationAttribute(name="before", containingElement="interceptor")
    public void setBeforeInterceptor(String beforeClass) {
        this.testImmutability("before");
        this.before = beforeClass;
    }

    public void setBeforeInterceptor(Class<? extends CommandInterceptor> interceptorClass) {
        this.setBeforeInterceptor(interceptorClass.getName());
    }

    public CommandInterceptor getInterceptor() {
        return this.interceptor;
    }

    public boolean isFirst() {
        return this.isFirst;
    }

    public boolean isLast() {
        return this.isLast;
    }

    public int getIndex() {
        return this.index;
    }

    public String getAfter() {
        return this.after;
    }

    public String getBefore() {
        return this.before;
    }

    public String toString() {
        return "CustomInterceptorConfig{interceptor='" + this.interceptor + '\'' + ", isFirst=" + this.isFirst + ", isLast=" + this.isLast + ", index=" + this.index + ", after='" + this.after + '\'' + ", before='" + this.before + '\'' + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CustomInterceptorConfig)) {
            return false;
        }
        CustomInterceptorConfig that = (CustomInterceptorConfig)o;
        if (this.index != that.index) {
            return false;
        }
        if (this.isFirst != that.isFirst) {
            return false;
        }
        if (this.isLast != that.isLast) {
            return false;
        }
        if (this.after != null ? !this.after.equals(that.after) : that.after != null) {
            return false;
        }
        if (this.before != null ? !this.before.equals(that.before) : that.before != null) {
            return false;
        }
        return !(this.interceptor != null ? !this.interceptor.equals(that.interceptor) : that.interceptor != null);
    }

    public int hashCode() {
        int result = this.interceptor != null ? this.interceptor.hashCode() : 0;
        result = 31 * result + (this.isFirst ? 1 : 0);
        result = 31 * result + (this.isLast ? 1 : 0);
        result = 31 * result + this.index;
        result = 31 * result + (this.after != null ? this.after.hashCode() : 0);
        result = 31 * result + (this.before != null ? this.before.hashCode() : 0);
        return result;
    }

    @Override
    public CustomInterceptorConfig clone() throws CloneNotSupportedException {
        CustomInterceptorConfig dolly = (CustomInterceptorConfig)super.clone();
        dolly.interceptor = this.interceptor;
        dolly.isFirst = this.isFirst;
        dolly.isLast = this.isLast;
        dolly.after = this.after;
        dolly.before = this.before;
        return dolly;
    }
}

