/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.infinispan.Cache;
import org.infinispan.commands.CommandsFactory;
import org.infinispan.commands.LockControlCommand;
import org.infinispan.commands.ReplicableCommand;
import org.infinispan.commands.control.StateTransferControlCommand;
import org.infinispan.commands.read.EntrySetCommand;
import org.infinispan.commands.read.GetKeyValueCommand;
import org.infinispan.commands.read.KeySetCommand;
import org.infinispan.commands.read.SizeCommand;
import org.infinispan.commands.read.ValuesCommand;
import org.infinispan.commands.remote.ClusteredGetCommand;
import org.infinispan.commands.remote.MultipleRpcCommand;
import org.infinispan.commands.remote.SingleRpcCommand;
import org.infinispan.commands.tx.CommitCommand;
import org.infinispan.commands.tx.PrepareCommand;
import org.infinispan.commands.tx.RollbackCommand;
import org.infinispan.commands.write.ClearCommand;
import org.infinispan.commands.write.EvictCommand;
import org.infinispan.commands.write.InvalidateCommand;
import org.infinispan.commands.write.InvalidateL1Command;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.commands.write.PutMapCommand;
import org.infinispan.commands.write.RemoveCommand;
import org.infinispan.commands.write.ReplaceCommand;
import org.infinispan.commands.write.WriteCommand;
import org.infinispan.container.DataContainer;
import org.infinispan.context.InvocationContextContainer;
import org.infinispan.distribution.DistributionManager;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.interceptors.InterceptorChain;
import org.infinispan.loaders.CacheLoaderManager;
import org.infinispan.notifications.cachelistener.CacheNotifier;
import org.infinispan.transaction.xa.GlobalTransaction;
import org.infinispan.transaction.xa.TransactionTable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandsFactoryImpl
implements CommandsFactory {
    private DataContainer dataContainer;
    private CacheNotifier notifier;
    private Cache cache;
    private CacheLoaderManager cacheLoaderManager;
    private String cacheName;
    SizeCommand cachedSizeCommand;
    KeySetCommand cachedKeySetCommand;
    ValuesCommand cachedValuesCommand;
    EntrySetCommand cachedEntrySetCommand;
    private InterceptorChain interceptorChain;
    private DistributionManager distributionManager;
    private InvocationContextContainer icc;
    private TransactionTable txTable;

    @Inject
    public void setupDependencies(DataContainer container, CacheNotifier notifier, Cache cache, InterceptorChain interceptorChain, CacheLoaderManager clManager, DistributionManager distributionManager, InvocationContextContainer icc, TransactionTable txTable) {
        this.dataContainer = container;
        this.notifier = notifier;
        this.cache = cache;
        this.interceptorChain = interceptorChain;
        this.cacheLoaderManager = clManager;
        this.distributionManager = distributionManager;
        this.icc = icc;
        this.txTable = txTable;
    }

    @Start(priority=1)
    public void start() {
        this.cacheName = this.cache.getName();
    }

    @Override
    public PutKeyValueCommand buildPutKeyValueCommand(Object key, Object value, long lifespanMillis, long maxIdleTimeMillis) {
        return new PutKeyValueCommand(key, value, false, this.notifier, lifespanMillis, maxIdleTimeMillis);
    }

    @Override
    public RemoveCommand buildRemoveCommand(Object key, Object value) {
        return new RemoveCommand(key, value, this.notifier);
    }

    @Override
    public InvalidateCommand buildInvalidateCommand(Object ... keys) {
        return new InvalidateCommand(this.notifier, keys);
    }

    @Override
    public InvalidateCommand buildInvalidateFromL1Command(Object ... keys) {
        return new InvalidateL1Command(this.distributionManager, this.notifier, keys);
    }

    @Override
    public ReplaceCommand buildReplaceCommand(Object key, Object oldValue, Object newValue, long lifespan, long maxIdleTimeMillis) {
        return new ReplaceCommand(key, oldValue, newValue, lifespan, maxIdleTimeMillis);
    }

    @Override
    public SizeCommand buildSizeCommand() {
        if (this.cachedSizeCommand == null) {
            this.cachedSizeCommand = new SizeCommand(this.dataContainer);
        }
        return this.cachedSizeCommand;
    }

    @Override
    public KeySetCommand buildKeySetCommand() {
        if (this.cachedKeySetCommand == null) {
            this.cachedKeySetCommand = new KeySetCommand(this.dataContainer);
        }
        return this.cachedKeySetCommand;
    }

    @Override
    public ValuesCommand buildValuesCommand() {
        if (this.cachedValuesCommand == null) {
            this.cachedValuesCommand = new ValuesCommand(this.dataContainer);
        }
        return this.cachedValuesCommand;
    }

    @Override
    public EntrySetCommand buildEntrySetCommand() {
        if (this.cachedEntrySetCommand == null) {
            this.cachedEntrySetCommand = new EntrySetCommand(this.dataContainer);
        }
        return this.cachedEntrySetCommand;
    }

    @Override
    public GetKeyValueCommand buildGetKeyValueCommand(Object key) {
        return new GetKeyValueCommand(key, this.notifier);
    }

    @Override
    public PutMapCommand buildPutMapCommand(Map map, long lifespan, long maxIdleTimeMillis) {
        return new PutMapCommand(map, this.notifier, lifespan, maxIdleTimeMillis);
    }

    @Override
    public ClearCommand buildClearCommand() {
        return new ClearCommand(this.notifier);
    }

    @Override
    public EvictCommand buildEvictCommand(Object key) {
        EvictCommand command = new EvictCommand(key, this.notifier);
        return command;
    }

    @Override
    public PrepareCommand buildPrepareCommand(GlobalTransaction gtx, List<WriteCommand> modifications, boolean onePhaseCommit) {
        PrepareCommand command = new PrepareCommand(gtx, modifications, onePhaseCommit);
        command.setCacheName(this.cacheName);
        return command;
    }

    @Override
    public CommitCommand buildCommitCommand(GlobalTransaction gtx) {
        CommitCommand commitCommand = new CommitCommand(gtx);
        commitCommand.setCacheName(this.cacheName);
        return commitCommand;
    }

    @Override
    public RollbackCommand buildRollbackCommand(GlobalTransaction gtx) {
        RollbackCommand rollbackCommand = new RollbackCommand(gtx);
        rollbackCommand.setCacheName(this.cacheName);
        return rollbackCommand;
    }

    @Override
    public MultipleRpcCommand buildReplicateCommand(List<ReplicableCommand> toReplicate) {
        return new MultipleRpcCommand(toReplicate, this.cacheName);
    }

    @Override
    public SingleRpcCommand buildSingleRpcCommand(ReplicableCommand call) {
        return new SingleRpcCommand(this.cacheName, call);
    }

    @Override
    public StateTransferControlCommand buildStateTransferControlCommand(boolean block) {
        return new StateTransferControlCommand(block);
    }

    @Override
    public ClusteredGetCommand buildClusteredGetCommand(Object key) {
        return new ClusteredGetCommand(key, this.cacheName);
    }

    @Override
    public void initializeReplicableCommand(ReplicableCommand c) {
        if (c == null) {
            return;
        }
        switch (c.getCommandId()) {
            case 8: {
                ((PutKeyValueCommand)c).init(this.notifier);
                break;
            }
            case 9: {
                ((PutMapCommand)c).init(this.notifier);
                break;
            }
            case 10: {
                ((RemoveCommand)c).init(this.notifier);
                break;
            }
            case 2: {
                MultipleRpcCommand rc = (MultipleRpcCommand)c;
                rc.init(this.interceptorChain, this.icc);
                if (rc.getCommands() == null) break;
                for (ReplicableCommand nested : rc.getCommands()) {
                    this.initializeReplicableCommand(nested);
                }
                break;
            }
            case 1: {
                SingleRpcCommand src = (SingleRpcCommand)c;
                src.init(this.interceptorChain, this.icc);
                if (src.getCommand() == null) break;
                this.initializeReplicableCommand(src.getCommand());
                break;
            }
            case 6: {
                InvalidateCommand ic = (InvalidateCommand)c;
                ic.init(this.notifier);
                break;
            }
            case 7: {
                InvalidateL1Command ilc = (InvalidateL1Command)c;
                ilc.init(this.distributionManager, this.notifier);
                break;
            }
            case 12: {
                PrepareCommand pc = (PrepareCommand)c;
                pc.init(this.interceptorChain, this.icc, this.txTable);
                pc.initialize(this.notifier);
                if (pc.getModifications() == null) break;
                for (WriteCommand nested : pc.getModifications()) {
                    this.initializeReplicableCommand(nested);
                }
                break;
            }
            case 14: {
                CommitCommand commitCommand = (CommitCommand)c;
                commitCommand.init(this.interceptorChain, this.icc, this.txTable);
                break;
            }
            case 13: {
                RollbackCommand rollbackCommand = (RollbackCommand)c;
                rollbackCommand.init(this.interceptorChain, this.icc, this.txTable);
                break;
            }
            case 5: {
                ClearCommand cc = (ClearCommand)c;
                cc.init(this.notifier);
                break;
            }
            case 16: {
                ClusteredGetCommand clusteredGetCommand = (ClusteredGetCommand)c;
                clusteredGetCommand.initialize(this.dataContainer, this.icc, this, this.interceptorChain);
                break;
            }
            case 3: {
                LockControlCommand lcc = (LockControlCommand)c;
                lcc.init(this.interceptorChain, this.icc, this.txTable);
            }
        }
    }

    @Override
    public LockControlCommand buildLockControlCommand(Collection keys, boolean implicit) {
        return new LockControlCommand(keys, this.cacheName, implicit);
    }
}

