/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.util;

import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.text.NumberFormat;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Util {
    public static Class loadClass(String classname) throws ClassNotFoundException {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (cl == null) {
            cl = ClassLoader.getSystemClassLoader();
        }
        return cl.loadClass(classname);
    }

    public static <T> T getInstance(Class<T> clazz) throws Exception {
        Object instance;
        try {
            Method factoryMethod = clazz.getMethod("getInstance", new Class[0]);
            instance = factoryMethod.invoke(null, new Object[0]);
        }
        catch (Exception e) {
            instance = clazz.newInstance();
        }
        return instance;
    }

    public static Object getInstance(String classname) throws Exception {
        if (classname == null) {
            throw new IllegalArgumentException("Cannot load null class!");
        }
        Class clazz = Util.loadClass(classname);
        return Util.getInstance(clazz);
    }

    private Util() {
    }

    public static boolean safeEquals(Object a, Object b) {
        return a == b || a != null && a.equals(b);
    }

    public static String prettyPrintTime(long millis) {
        if (millis < 1000L) {
            return millis + " milliseconds";
        }
        NumberFormat nf = NumberFormat.getNumberInstance();
        nf.setMaximumFractionDigits(2);
        double toPrint = (double)millis / 1000.0;
        if (toPrint < 300.0) {
            return nf.format(toPrint) + " seconds";
        }
        if ((toPrint /= 60.0) < 120.0) {
            return nf.format(toPrint) + " minutes";
        }
        return nf.format(toPrint /= 60.0) + " hours";
    }

    public static void closeStream(InputStream i) {
        if (i == null) {
            return;
        }
        try {
            i.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void closeInput(ObjectInput i) {
        if (i == null) {
            return;
        }
        try {
            i.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void flushAndCloseStream(OutputStream o) {
        if (o == null) {
            return;
        }
        try {
            o.flush();
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            o.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void flushAndCloseOutput(ObjectOutput o) {
        if (o == null) {
            return;
        }
        try {
            o.flush();
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            o.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static class MapModifications {
        public final Map<Object, Object> addedEntries = new HashMap<Object, Object>();
        public final Map<Object, Object> removedEntries = new HashMap<Object, Object>();
        public final Map<Object, Object> modifiedEntries = new HashMap<Object, Object>();

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MapModifications that = (MapModifications)o;
            if (this.addedEntries != null ? !((Object)this.addedEntries).equals(that.addedEntries) : that.addedEntries != null) {
                return false;
            }
            if (this.modifiedEntries != null ? !((Object)this.modifiedEntries).equals(that.modifiedEntries) : that.modifiedEntries != null) {
                return false;
            }
            return !(this.removedEntries != null ? !((Object)this.removedEntries).equals(that.removedEntries) : that.removedEntries != null);
        }

        public int hashCode() {
            int result = this.addedEntries != null ? ((Object)this.addedEntries).hashCode() : 0;
            result = 31 * result + (this.removedEntries != null ? ((Object)this.removedEntries).hashCode() : 0);
            result = 31 * result + (this.modifiedEntries != null ? ((Object)this.modifiedEntries).hashCode() : 0);
            return result;
        }

        public String toString() {
            return "Added Entries " + this.addedEntries + " Removeed Entries " + this.removedEntries + " Modified Entries " + this.modifiedEntries;
        }
    }
}

