/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.util;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.Array;
import java.util.AbstractList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import net.jcip.annotations.Immutable;
import org.infinispan.util.Immutables;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Immutable
public class ImmutableListCopy<E>
extends AbstractList<E>
implements Externalizable,
Immutables.Immutable {
    private static final long serialVersionUID = 10929568968966L;
    private E[] elements;
    private int size;

    public ImmutableListCopy() {
    }

    public ImmutableListCopy(Collection<? extends E> c) {
        this.size = c.size();
        Object[] el = new Object[this.size];
        el = c.toArray(el);
        this.elements = el;
    }

    public ImmutableListCopy(E[] array) {
        this.size = array.length;
        this.elements = array;
    }

    public ImmutableListCopy(Collection<? extends E> collection1, Collection<? extends E> collection2) {
        this.size = collection1.size() + collection2.size();
        this.elements = new Object[this.size];
        Object[] c1 = new Object[collection1.size()];
        Object[] c2 = new Object[collection2.size()];
        c1 = collection1.toArray(c1);
        c2 = collection2.toArray(c2);
        System.arraycopy(c1, 0, this.elements, 0, c1.length);
        System.arraycopy(c2, 0, this.elements, c1.length, c2.length);
    }

    @Override
    public final int size() {
        return this.size;
    }

    @Override
    public final boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public final boolean contains(Object o) {
        return this.indexOf(o) >= 0;
    }

    @Override
    public final Iterator<E> iterator() {
        return new ImmutableIterator();
    }

    @Override
    public final Object[] toArray() {
        Object[] result = new Object[this.size];
        System.arraycopy(this.elements, 0, result, 0, this.size);
        return result;
    }

    @Override
    public final <T> T[] toArray(T[] a) {
        if (a.length < this.size) {
            a = (Object[])Array.newInstance(a.getClass().getComponentType(), this.size);
        }
        System.arraycopy(this.elements, 0, a, 0, this.size);
        if (a.length > this.size) {
            a[this.size] = null;
        }
        return a;
    }

    @Override
    public final boolean add(E o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final boolean addAll(Collection<? extends E> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final boolean addAll(int index, Collection<? extends E> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final E get(int index) {
        if (index >= this.size || index < 0) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size);
        }
        return this.elements[index];
    }

    @Override
    public final int indexOf(Object o) {
        if (o == null) {
            for (int i = 0; i < this.size; ++i) {
                if (this.elements[i] != null) continue;
                return i;
            }
        } else {
            for (int i = 0; i < this.size; ++i) {
                if (!o.equals(this.elements[i])) continue;
                return i;
            }
        }
        return -1;
    }

    @Override
    public final int lastIndexOf(Object o) {
        if (o == null) {
            for (int i = this.size - 1; i >= 0; --i) {
                if (this.elements[i] != null) continue;
                return i;
            }
        } else {
            for (int i = this.size - 1; i >= 0; --i) {
                if (!o.equals(this.elements[i])) continue;
                return i;
            }
        }
        return -1;
    }

    @Override
    public final ListIterator<E> listIterator() {
        return new ImmutableIterator();
    }

    @Override
    public final ListIterator<E> listIterator(int index) {
        return new ImmutableIterator(index);
    }

    @Override
    public final List<E> subList(int fromIndex, int toIndex) {
        return new ImmutableSubList(fromIndex, toIndex);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.size);
        for (E e : this.elements) {
            out.writeObject(e);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.size = in.readInt();
        this.elements = new Object[this.size];
        for (int i = 0; i < this.size; ++i) {
            this.elements[i] = in.readObject();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ImmutableSubList<E>
    extends AbstractList<E> {
        private int offset;
        private int size;

        ImmutableSubList(int fromIndex, int toIndex) {
            if (fromIndex < 0 || toIndex > ImmutableListCopy.this.size || fromIndex > toIndex) {
                throw new IllegalArgumentException("fromIndex(" + fromIndex + "), toIndex(" + toIndex + "), size (" + ImmutableListCopy.this.size + "), List=" + ImmutableListCopy.this.toString());
            }
            this.offset = fromIndex;
            this.size = toIndex - fromIndex;
        }

        @Override
        public final E get(int index) {
            if (index < 0 || index >= this.size) {
                throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size);
            }
            return ImmutableListCopy.this.get(index + this.offset);
        }

        @Override
        public final int size() {
            return this.size;
        }

        @Override
        protected final void removeRange(int fromIndex, int toIndex) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final boolean addAll(Collection<? extends E> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final boolean addAll(int index, Collection<? extends E> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final Iterator<E> iterator() {
            return this.listIterator();
        }

        @Override
        public final ListIterator<E> listIterator(final int index) {
            if (index < 0 || index != 0 && index >= this.size) {
                throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size);
            }
            return new ListIterator<E>(){
                private ListIterator i;
                {
                    this.i = ImmutableListCopy.this.listIterator(index + ImmutableSubList.this.offset);
                }

                @Override
                public boolean hasNext() {
                    return this.nextIndex() < ImmutableSubList.this.size;
                }

                @Override
                public E next() {
                    if (this.hasNext()) {
                        return this.i.next();
                    }
                    throw new NoSuchElementException();
                }

                @Override
                public boolean hasPrevious() {
                    return this.previousIndex() >= 0;
                }

                @Override
                public E previous() {
                    if (this.hasPrevious()) {
                        return this.i.previous();
                    }
                    throw new NoSuchElementException();
                }

                @Override
                public int nextIndex() {
                    return this.i.nextIndex() - ImmutableSubList.this.offset;
                }

                @Override
                public int previousIndex() {
                    return this.i.previousIndex() - ImmutableSubList.this.offset;
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }

                @Override
                public void set(E o) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public void add(E o) {
                    throw new UnsupportedOperationException();
                }
            };
        }

        @Override
        public final List<E> subList(int fromIndex, int toIndex) {
            return new ImmutableSubList<E>(this.offset + fromIndex, this.offset + toIndex);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ImmutableIterator
    implements ListIterator<E> {
        int cursor = 0;

        ImmutableIterator(int index) {
            if (index < 0 || index > ImmutableListCopy.this.size()) {
                throw new IndexOutOfBoundsException("Index: " + index);
            }
            this.cursor = index;
        }

        ImmutableIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.cursor != ImmutableListCopy.this.size;
        }

        @Override
        public E next() {
            try {
                return ImmutableListCopy.this.get(this.cursor++);
            }
            catch (IndexOutOfBoundsException e) {
                throw new NoSuchElementException();
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean hasPrevious() {
            return this.cursor != 0;
        }

        @Override
        public E previous() {
            try {
                return ImmutableListCopy.this.get(--this.cursor);
            }
            catch (IndexOutOfBoundsException e) {
                throw new NoSuchElementException();
            }
        }

        @Override
        public int nextIndex() {
            return this.cursor;
        }

        @Override
        public int previousIndex() {
            return this.cursor - 1;
        }

        @Override
        public void set(E o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(E o) {
            throw new UnsupportedOperationException();
        }
    }
}

