/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.marshall.jboss.externalizers;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.infinispan.container.entries.InternalEntryFactory;
import org.infinispan.container.entries.TransientCacheValue;
import org.infinispan.io.UnsignedNumeric;
import org.infinispan.marshall.jboss.Externalizer;
import org.jboss.marshalling.Marshaller;
import org.jboss.marshalling.Unmarshaller;

public class TransientCacheValueExternalizer
implements Externalizer {
    private static final long serialVersionUID = 7600812173331344919L;

    public void writeObject(Marshaller output, Object subject) throws IOException {
        TransientCacheValue icv = (TransientCacheValue)subject;
        output.writeObject(icv.getValue());
        UnsignedNumeric.writeUnsignedLong((ObjectOutput)output, icv.getLastUsed());
        output.writeLong(icv.getMaxIdle());
    }

    public Object readObject(Unmarshaller input) throws IOException, ClassNotFoundException {
        Object v = input.readObject();
        long lastUsed = UnsignedNumeric.readUnsignedLong((ObjectInput)input);
        Long maxIdle = input.readLong();
        return InternalEntryFactory.createValue(v, -1L, -1L, lastUsed, maxIdle);
    }
}

