/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.marshall.jboss.externalizers;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import net.jcip.annotations.Immutable;
import org.infinispan.commands.write.WriteCommand;
import org.infinispan.marshall.jboss.Externalizer;
import org.infinispan.marshall.jboss.MarshallUtil;
import org.infinispan.transaction.TransactionLog;
import org.infinispan.transaction.xa.GlobalTransaction;
import org.jboss.marshalling.Marshaller;
import org.jboss.marshalling.Unmarshaller;

@Immutable
public class TransactionLogExternalizer
implements Externalizer {
    private static final long serialVersionUID = -7341096933735222157L;

    public void writeObject(Marshaller output, Object subject) throws IOException {
        TransactionLog.LogEntry le = (TransactionLog.LogEntry)subject;
        output.writeObject((Object)le.getTransaction());
        WriteCommand[] cmds = le.getModifications();
        MarshallUtil.writeUnsignedInt((ObjectOutput)output, cmds.length);
        for (WriteCommand c : cmds) {
            output.writeObject((Object)c);
        }
    }

    public Object readObject(Unmarshaller input) throws IOException, ClassNotFoundException {
        GlobalTransaction gtx = (GlobalTransaction)input.readObject();
        int numCommands = MarshallUtil.readUnsignedInt((ObjectInput)input);
        WriteCommand[] cmds = new WriteCommand[numCommands];
        for (int i = 0; i < numCommands; ++i) {
            cmds[i] = (WriteCommand)input.readObject();
        }
        return new TransactionLog.LogEntry(gtx, cmds);
    }
}

