/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.marshall.jboss.externalizers;

import java.io.IOException;
import net.jcip.annotations.Immutable;
import org.infinispan.marshall.jboss.Externalizer;
import org.infinispan.remoting.responses.ExtendedResponse;
import org.infinispan.remoting.responses.Response;
import org.jboss.marshalling.Marshaller;
import org.jboss.marshalling.Unmarshaller;

@Immutable
public class ExtendedResponseExternalizer
implements Externalizer {
    private static final long serialVersionUID = 1529506931234856884L;

    public void writeObject(Marshaller output, Object subject) throws IOException {
        ExtendedResponse er = (ExtendedResponse)subject;
        output.writeBoolean(er.isReplayIgnoredRequests());
        output.writeObject((Object)er.getResponse());
    }

    public Object readObject(Unmarshaller input) throws IOException, ClassNotFoundException {
        boolean replayIgnoredRequests = input.readBoolean();
        Response response = (Response)input.readObject();
        return new ExtendedResponse(response, replayIgnoredRequests);
    }
}

