/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.marshall;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.infinispan.CacheException;
import org.infinispan.atomic.DeltaAware;
import org.infinispan.commands.RemoteCommandFactory;
import org.infinispan.commands.ReplicableCommand;
import org.infinispan.commands.write.WriteCommand;
import org.infinispan.container.entries.ImmortalCacheEntry;
import org.infinispan.container.entries.ImmortalCacheValue;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.container.entries.InternalCacheValue;
import org.infinispan.container.entries.InternalEntryFactory;
import org.infinispan.container.entries.MortalCacheEntry;
import org.infinispan.container.entries.MortalCacheValue;
import org.infinispan.container.entries.TransientCacheEntry;
import org.infinispan.container.entries.TransientCacheValue;
import org.infinispan.container.entries.TransientMortalCacheEntry;
import org.infinispan.container.entries.TransientMortalCacheValue;
import org.infinispan.io.ByteBuffer;
import org.infinispan.io.ExposedByteArrayOutputStream;
import org.infinispan.io.UnsignedNumeric;
import org.infinispan.loaders.bucket.Bucket;
import org.infinispan.marshall.AbstractMarshaller;
import org.infinispan.marshall.MarshalledValue;
import org.infinispan.marshall.Marshaller;
import org.infinispan.marshall.UnmarshalledReferences;
import org.infinispan.remoting.responses.ExceptionResponse;
import org.infinispan.remoting.responses.ExtendedResponse;
import org.infinispan.remoting.responses.RequestIgnoredResponse;
import org.infinispan.remoting.responses.Response;
import org.infinispan.remoting.responses.SuccessfulResponse;
import org.infinispan.remoting.responses.UnsuccessfulResponse;
import org.infinispan.remoting.transport.Address;
import org.infinispan.remoting.transport.jgroups.JGroupsAddress;
import org.infinispan.transaction.TransactionLog;
import org.infinispan.transaction.xa.GlobalTransaction;
import org.infinispan.util.FastCopyHashMap;
import org.infinispan.util.Immutables;
import org.infinispan.util.Util;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.jboss.util.stream.MarshalledValueInputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Deprecated
public class MarshallerImpl
extends AbstractMarshaller {
    protected static final int MAGICNUMBER_GTX = 1;
    protected static final int MAGICNUMBER_JG_ADDRESS = 2;
    protected static final int MAGICNUMBER_ARRAY_LIST = 3;
    protected static final int MAGICNUMBER_INTEGER = 4;
    protected static final int MAGICNUMBER_LONG = 5;
    protected static final int MAGICNUMBER_BOOLEAN = 6;
    protected static final int MAGICNUMBER_STRING = 7;
    protected static final int MAGICNUMBER_LINKED_LIST = 8;
    protected static final int MAGICNUMBER_HASH_MAP = 9;
    protected static final int MAGICNUMBER_TREE_MAP = 10;
    protected static final int MAGICNUMBER_HASH_SET = 11;
    protected static final int MAGICNUMBER_TREE_SET = 12;
    protected static final int MAGICNUMBER_SHORT = 13;
    protected static final int MAGICNUMBER_IMMUTABLE_MAPCOPY = 14;
    protected static final int MAGICNUMBER_MARSHALLEDVALUE = 15;
    protected static final int MAGICNUMBER_FASTCOPY_HASHMAP = 16;
    protected static final int MAGICNUMBER_ARRAY = 17;
    protected static final int MAGICNUMBER_BYTE = 18;
    protected static final int MAGICNUMBER_CHAR = 19;
    protected static final int MAGICNUMBER_FLOAT = 20;
    protected static final int MAGICNUMBER_DOUBLE = 21;
    protected static final int MAGICNUMBER_OBJECT = 22;
    protected static final int MAGICNUMBER_SINGLETON_LIST = 23;
    protected static final int MAGICNUMBER_COMMAND = 24;
    protected static final int MAGICNUMBER_TRANSACTION_LOG = 25;
    protected static final int MAGICNUMBER_ICE_IMMORTAL = 26;
    protected static final int MAGICNUMBER_ICE_MORTAL = 27;
    protected static final int MAGICNUMBER_ICE_TRANSIENT = 28;
    protected static final int MAGICNUMBER_ICE_TRANSIENT_MORTAL = 29;
    protected static final int MAGICNUMBER_ICV_IMMORTAL = 30;
    protected static final int MAGICNUMBER_ICV_MORTAL = 31;
    protected static final int MAGICNUMBER_ICV_TRANSIENT = 32;
    protected static final int MAGICNUMBER_ICV_TRANSIENT_MORTAL = 33;
    protected static final int MAGICNUMBER_REQUEST_IGNORED_RESPONSE = 34;
    protected static final int MAGICNUMBER_EXTENDED_RESPONSE = 35;
    protected static final int MAGICNUMBER_EXCEPTION_RESPONSE = 36;
    protected static final int MAGICNUMBER_SUCCESSFUL_RESPONSE = 37;
    protected static final int MAGICNUMBER_UNSUCCESSFUL_RESPONSE = 38;
    protected static final int MAGICNUMBER_CACHESTORE_BUCKET = 39;
    protected static final int MAGICNUMBER_NULL = 99;
    protected static final int MAGICNUMBER_SERIALIZABLE = 100;
    protected static final int MAGICNUMBER_REF = 101;
    protected Log log;
    protected boolean trace;
    private RemoteCommandFactory remoteCommandFactory;
    protected ClassLoader defaultClassLoader;
    protected boolean useRefs = false;

    public MarshallerImpl() {
        this.initLogger();
        this.useRefs = false;
    }

    public void init(ClassLoader defaultClassLoader, RemoteCommandFactory remoteCommandFactory) {
        this.defaultClassLoader = defaultClassLoader;
        this.remoteCommandFactory = remoteCommandFactory;
    }

    protected void initLogger() {
        this.log = LogFactory.getLog(this.getClass());
        this.trace = this.log.isTraceEnabled();
    }

    @Override
    public byte[] objectToByteBuffer(Object obj) throws IOException {
        ByteBuffer b = this.objectToBuffer(obj);
        byte[] bytes = new byte[b.getLength()];
        System.arraycopy(b.getBuf(), b.getOffset(), bytes, 0, b.getLength());
        return bytes;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void marshallObject(Object o, ObjectOutput out, Map<Object, Integer> refMap) throws IOException {
        if (o != null && o.getClass().isArray() && this.isKnownType(o.getClass().getComponentType())) {
            this.marshallArray(o, out, refMap);
            return;
        } else if (o == null) {
            out.writeByte(99);
            return;
        } else if (this.useRefs && refMap.containsKey(o)) {
            out.writeByte(101);
            this.writeReference(out, refMap.get(o));
            return;
        } else if (o instanceof ReplicableCommand) {
            ReplicableCommand command = (ReplicableCommand)o;
            if (command.getCommandId() <= -1) throw new IllegalArgumentException("Command does not have a valid method id!");
            out.writeByte(24);
            this.marshallCommand(command, out, refMap);
            return;
        } else if (o instanceof MarshalledValue) {
            out.writeByte(15);
            this.marshallMarshalledValue((MarshalledValue)o, out, refMap);
            return;
        } else if (o instanceof DeltaAware) {
            out.writeByte(100);
            out.writeObject(((DeltaAware)o).delta());
            return;
        } else if (o instanceof GlobalTransaction) {
            out.writeByte(1);
            if (this.useRefs) {
                this.writeReference(out, this.createReference(o, refMap));
            }
            this.marshallGlobalTransaction((GlobalTransaction)o, out, refMap);
            return;
        } else if (o instanceof JGroupsAddress) {
            out.writeByte(2);
            this.marshallJGroupsAddress((JGroupsAddress)o, out);
            return;
        } else if (o instanceof Response) {
            this.marshallResponse((Response)o, out, refMap);
            return;
        } else if (o instanceof InternalCacheEntry) {
            this.marshallInternalCacheEntry((InternalCacheEntry)o, out, refMap);
            return;
        } else if (o instanceof InternalCacheValue) {
            this.marshallInternalCacheValue((InternalCacheValue)o, out, refMap);
            return;
        } else if (o.getClass().equals(ArrayList.class)) {
            out.writeByte(3);
            this.marshallCollection((Collection)o, out, refMap);
            return;
        } else if (o instanceof LinkedList) {
            out.writeByte(8);
            this.marshallCollection((Collection)o, out, refMap);
            return;
        } else if (o.getClass().getName().equals("java.util.Collections$SingletonList")) {
            out.writeByte(23);
            this.marshallObject(((List)o).get(0), out, refMap);
            return;
        } else if (o.getClass().equals(HashMap.class)) {
            out.writeByte(9);
            this.marshallMap((Map)o, out, refMap);
            return;
        } else if (o.getClass().equals(TreeMap.class)) {
            out.writeByte(10);
            this.marshallMap((Map)o, out, refMap);
            return;
        } else if (o.getClass().equals(FastCopyHashMap.class)) {
            out.writeByte(16);
            this.marshallMap((Map)o, out, refMap);
            return;
        } else if (o instanceof Map && Immutables.isImmutable(o)) {
            out.writeByte(14);
            this.marshallMap((Map)o, out, refMap);
            return;
        } else if (o.getClass().equals(HashSet.class)) {
            out.writeByte(11);
            this.marshallCollection((Collection)o, out, refMap);
            return;
        } else if (o.getClass().equals(TreeSet.class)) {
            out.writeByte(12);
            this.marshallCollection((Collection)o, out, refMap);
            return;
        } else if (o instanceof Boolean) {
            out.writeByte(6);
            out.writeBoolean((Boolean)o);
            return;
        } else if (o instanceof Integer) {
            out.writeByte(4);
            out.writeInt((Integer)o);
            return;
        } else if (o instanceof Long) {
            out.writeByte(5);
            out.writeLong((Long)o);
            return;
        } else if (o instanceof Short) {
            out.writeByte(13);
            out.writeShort(((Short)o).shortValue());
            return;
        } else if (o instanceof Byte) {
            out.writeByte(18);
            out.writeByte(((Byte)o).byteValue());
            return;
        } else if (o instanceof Bucket) {
            out.writeByte(39);
            this.marshallBucket((Bucket)o, out, refMap);
            return;
        } else if (o instanceof String) {
            out.writeByte(7);
            if (this.useRefs) {
                this.writeReference(out, this.createReference(o, refMap));
            }
            this.marshallString((String)o, out);
            return;
        } else if (o instanceof TransactionLog.LogEntry) {
            out.writeByte(25);
            TransactionLog.LogEntry le = (TransactionLog.LogEntry)o;
            this.marshallObject(le.getTransaction(), out, refMap);
            WriteCommand[] cmds = le.getModifications();
            this.writeUnsignedInt(out, cmds.length);
            for (WriteCommand c : cmds) {
                this.marshallObject(c, out, refMap);
            }
            return;
        } else {
            if (!(o instanceof Serializable)) throw new IOException("Don't know how to marshall object of type " + o.getClass());
            if (this.trace) {
                this.log.trace((Object)"WARNING: using object serialization for [{0}]", o.getClass());
            }
            out.writeByte(100);
            if (this.useRefs) {
                this.writeReference(out, this.createReference(o, refMap));
            }
            out.writeObject(o);
        }
    }

    private void marshallMarshalledValue(MarshalledValue mv, ObjectOutput out, Map<Object, Integer> refMap) throws IOException {
        byte[] raw = mv.getRaw();
        this.writeUnsignedInt(out, raw.length);
        out.write(raw);
        out.writeInt(mv.hashCode());
    }

    private void marshallBucket(Bucket b, ObjectOutput o, Map<Object, Integer> refMap) throws IOException {
        this.writeUnsignedInt(o, b.getNumEntries());
        for (InternalCacheEntry se : b.getEntries().values()) {
            this.marshallObject(se, o, refMap);
        }
    }

    private void marshallInternalCacheEntry(InternalCacheEntry ice, ObjectOutput out, Map<Object, Integer> refMap) throws IOException {
        if (ice.getClass().equals(ImmortalCacheEntry.class)) {
            out.writeByte(26);
            this.marshallObject(ice.getKey(), out, refMap);
            this.marshallObject(ice.getValue(), out, refMap);
        } else if (ice.getClass().equals(MortalCacheEntry.class)) {
            out.writeByte(27);
            this.marshallObject(ice.getKey(), out, refMap);
            this.marshallObject(ice.getValue(), out, refMap);
            this.writeUnsignedLong(out, ice.getCreated());
            this.marshallObject(ice.getLifespan(), out, refMap);
        } else if (ice.getClass().equals(TransientCacheEntry.class)) {
            out.writeByte(28);
            this.marshallObject(ice.getKey(), out, refMap);
            this.marshallObject(ice.getValue(), out, refMap);
            this.writeUnsignedLong(out, ice.getLastUsed());
            this.marshallObject(ice.getMaxIdle(), out, refMap);
        } else if (ice.getClass().equals(TransientMortalCacheEntry.class)) {
            out.writeByte(29);
            this.marshallObject(ice.getKey(), out, refMap);
            this.marshallObject(ice.getValue(), out, refMap);
            this.writeUnsignedLong(out, ice.getCreated());
            this.marshallObject(ice.getLifespan(), out, refMap);
            this.writeUnsignedLong(out, ice.getLastUsed());
            this.marshallObject(ice.getMaxIdle(), out, refMap);
        }
    }

    private void marshallInternalCacheValue(InternalCacheValue icv, ObjectOutput out, Map<Object, Integer> refMap) throws IOException {
        if (icv.getClass().equals(ImmortalCacheValue.class)) {
            out.writeByte(30);
            this.marshallObject(icv.getValue(), out, refMap);
        } else if (icv.getClass().equals(MortalCacheValue.class)) {
            out.writeByte(31);
            this.marshallObject(icv.getValue(), out, refMap);
            this.writeUnsignedLong(out, icv.getCreated());
            this.marshallObject(icv.getLifespan(), out, refMap);
        } else if (icv.getClass().equals(TransientCacheValue.class)) {
            out.writeByte(32);
            this.marshallObject(icv.getValue(), out, refMap);
            this.writeUnsignedLong(out, icv.getLastUsed());
            this.marshallObject(icv.getMaxIdle(), out, refMap);
        } else if (icv.getClass().equals(TransientMortalCacheValue.class)) {
            out.writeByte(33);
            this.marshallObject(icv.getValue(), out, refMap);
            this.writeUnsignedLong(out, icv.getCreated());
            this.marshallObject(icv.getLifespan(), out, refMap);
            this.writeUnsignedLong(out, icv.getLastUsed());
            this.marshallObject(icv.getMaxIdle(), out, refMap);
        }
    }

    protected void marshallString(String s, ObjectOutput out) throws IOException {
        out.writeObject(s);
    }

    private void marshallCommand(ReplicableCommand command, ObjectOutput out, Map<Object, Integer> refMap) throws IOException {
        out.writeShort(command.getCommandId());
        Object[] args = command.getParameters();
        int numArgs = args == null ? 0 : args.length;
        out.writeByte(numArgs);
        for (int i = 0; i < numArgs; ++i) {
            this.marshallObject(args[i], out, refMap);
        }
    }

    private int createReference(Object o, Map<Object, Integer> refMap) {
        int reference = refMap.size();
        refMap.put(o, reference);
        return reference;
    }

    private void marshallGlobalTransaction(GlobalTransaction globalTransaction, ObjectOutput out, Map<Object, Integer> refMap) throws IOException {
        out.writeLong(globalTransaction.getId());
        this.marshallObject(globalTransaction.getAddress(), out, refMap);
    }

    private void marshallJGroupsAddress(JGroupsAddress address, ObjectOutput out) throws IOException {
        out.writeObject(address.getJGroupsAddress());
    }

    private void marshallCollection(Collection c, ObjectOutput out, Map refMap) throws IOException {
        this.writeUnsignedInt(out, c.size());
        for (Object o : c) {
            this.marshallObject(o, out, refMap);
        }
    }

    private void marshallMap(Map map, ObjectOutput out, Map<Object, Integer> refMap) throws IOException {
        int mapSize = map.size();
        this.writeUnsignedInt(out, mapSize);
        if (mapSize == 0) {
            return;
        }
        for (Map.Entry me : map.entrySet()) {
            this.marshallObject(me.getKey(), out, refMap);
            this.marshallObject(me.getValue(), out, refMap);
        }
    }

    private void marshallResponse(Response response, ObjectOutput out, Map<Object, Integer> refMap) throws IOException {
        if (response instanceof RequestIgnoredResponse) {
            out.writeByte(34);
        } else if (response instanceof ExtendedResponse) {
            out.writeByte(35);
            ExtendedResponse er = (ExtendedResponse)response;
            out.writeBoolean(er.isReplayIgnoredRequests());
            this.marshallObject(er.getResponse(), out, refMap);
        } else if (response instanceof UnsuccessfulResponse) {
            out.writeByte(38);
        } else if (response instanceof SuccessfulResponse) {
            out.writeByte(37);
            this.marshallObject(((SuccessfulResponse)response).getResponseValue(), out, refMap);
        } else if (response instanceof ExceptionResponse) {
            out.writeByte(36);
            this.marshallObject(((ExceptionResponse)response).getException(), out, refMap);
        }
    }

    private Response unmarshallResponse(int magic, ObjectInput in, UnmarshalledReferences refMap) throws IOException, ClassNotFoundException {
        switch (magic) {
            case 34: {
                return RequestIgnoredResponse.INSTANCE;
            }
            case 38: {
                return UnsuccessfulResponse.INSTANCE;
            }
            case 37: {
                Object retval = this.unmarshallObject(in, refMap);
                return new SuccessfulResponse(retval);
            }
            case 36: {
                Exception e = (Exception)this.unmarshallObject(in, refMap);
                return new ExceptionResponse(e);
            }
            case 35: {
                boolean replay = in.readBoolean();
                Response response = (Response)this.unmarshallObject(in, refMap);
                return new ExtendedResponse(response, replay);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object unmarshallObject(ObjectInput in, ClassLoader loader, UnmarshalledReferences refMap, boolean overrideContextClassloaderOnThread) throws IOException, ClassNotFoundException {
        if (loader == null) {
            return this.unmarshallObject(in, refMap);
        }
        Thread currentThread = Thread.currentThread();
        ClassLoader old = currentThread.getContextClassLoader();
        try {
            if (overrideContextClassloaderOnThread || old == null) {
                currentThread.setContextClassLoader(loader);
            }
            Object object = this.unmarshallObject(in, refMap);
            return object;
        }
        finally {
            if (overrideContextClassloaderOnThread || old == null) {
                currentThread.setContextClassLoader(old);
            }
        }
    }

    protected Object unmarshallObject(ObjectInput in, UnmarshalledReferences refMap) throws IOException, ClassNotFoundException {
        byte magicNumber = in.readByte();
        int reference = 0;
        switch (magicNumber) {
            case 99: {
                return null;
            }
            case 101: {
                if (!this.useRefs) break;
                reference = this.readReference(in);
                return refMap.getReferencedObject(reference);
            }
            case 100: {
                if (this.useRefs) {
                    reference = this.readReference(in);
                }
                Object retVal = in.readObject();
                if (this.useRefs) {
                    refMap.putReferencedObject(reference, retVal);
                }
                return retVal;
            }
            case 15: {
                return this.unmarshallMarshalledValue(in, refMap);
            }
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                return this.unmarshallInternalCacheEntry(magicNumber, in, refMap);
            }
            case 30: 
            case 31: 
            case 32: 
            case 33: {
                return this.unmarshallInternalCacheValue(magicNumber, in, refMap);
            }
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: {
                return this.unmarshallResponse(magicNumber, in, refMap);
            }
            case 24: {
                ReplicableCommand retVal = this.unmarshallCommand(in, refMap);
                return retVal;
            }
            case 1: {
                if (this.useRefs) {
                    reference = this.readReference(in);
                }
                GlobalTransaction retVal = this.unmarshallGlobalTransaction(in, refMap);
                if (this.useRefs) {
                    refMap.putReferencedObject(reference, retVal);
                }
                return retVal;
            }
            case 2: {
                JGroupsAddress retVal = this.unmarshallJGroupsAddress(in);
                return retVal;
            }
            case 25: {
                GlobalTransaction gtx = (GlobalTransaction)this.unmarshallObject(in, refMap);
                int numCommands = this.readUnsignedInt(in);
                WriteCommand[] cmds = new WriteCommand[numCommands];
                for (int i = 0; i < numCommands; ++i) {
                    cmds[i] = (WriteCommand)this.unmarshallObject(in, refMap);
                }
                return new TransactionLog.LogEntry(gtx, cmds);
            }
            case 39: {
                return this.unmarshallBucket(in, refMap);
            }
            case 17: {
                return this.unmarshallArray(in, refMap);
            }
            case 3: {
                return this.unmarshallArrayList(in, refMap);
            }
            case 8: {
                return this.unmarshallLinkedList(in, refMap);
            }
            case 23: {
                return this.unmarshallSingletonList(in, refMap);
            }
            case 9: {
                return this.unmarshallHashMap(in, refMap);
            }
            case 10: {
                return this.unmarshallTreeMap(in, refMap);
            }
            case 11: {
                return this.unmarshallHashSet(in, refMap);
            }
            case 12: {
                return this.unmarshallTreeSet(in, refMap);
            }
            case 14: {
                return this.unmarshallMapCopy(in, refMap);
            }
            case 16: {
                return this.unmarshallFastCopyHashMap(in, refMap);
            }
            case 6: {
                return in.readBoolean() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 18: {
                return in.readByte();
            }
            case 4: {
                return in.readInt();
            }
            case 5: {
                return in.readLong();
            }
            case 13: {
                return in.readShort();
            }
            case 7: {
                if (this.useRefs) {
                    reference = this.readReference(in);
                }
                String retVal = this.unmarshallString(in);
                if (this.useRefs) {
                    refMap.putReferencedObject(reference, retVal);
                }
                return retVal;
            }
            default: {
                if (this.log.isErrorEnabled()) {
                    this.log.error("Unknown Magic Number " + magicNumber);
                }
                throw new IOException("Unknown magic number " + magicNumber);
            }
        }
        throw new IOException("Unknown magic number " + magicNumber);
    }

    private MarshalledValue unmarshallMarshalledValue(ObjectInput in, UnmarshalledReferences refs) throws IOException, ClassNotFoundException {
        int sz = this.readUnsignedInt(in);
        byte[] raw = new byte[sz];
        in.readFully(raw);
        int hc = in.readInt();
        return new MarshalledValue(raw, hc, (Marshaller)this);
    }

    private Bucket unmarshallBucket(ObjectInput input, UnmarshalledReferences references) throws IOException, ClassNotFoundException {
        Bucket b = new Bucket();
        int numEntries = this.readUnsignedInt(input);
        for (int i = 0; i < numEntries; ++i) {
            b.addEntry((InternalCacheEntry)this.unmarshallObject(input, references));
        }
        return b;
    }

    private InternalCacheEntry unmarshallInternalCacheEntry(byte magic, ObjectInput in, UnmarshalledReferences refMap) throws IOException, ClassNotFoundException {
        Object k = this.unmarshallObject(in, refMap);
        Object v = this.unmarshallObject(in, refMap);
        switch (magic) {
            case 26: {
                return InternalEntryFactory.create(k, v);
            }
            case 27: {
                return InternalEntryFactory.create(k, v, this.readUnsignedLong(in), (Long)this.unmarshallObject(in, refMap), -1L, -1L);
            }
            case 28: {
                return InternalEntryFactory.create(k, v, -1L, -1L, this.readUnsignedLong(in), (Long)this.unmarshallObject(in, refMap));
            }
            case 29: {
                return InternalEntryFactory.create(k, v, this.readUnsignedLong(in), (Long)this.unmarshallObject(in, refMap), this.readUnsignedLong(in), (Long)this.unmarshallObject(in, refMap));
            }
        }
        throw new IllegalArgumentException("Unknown magic number " + magic);
    }

    private InternalCacheValue unmarshallInternalCacheValue(byte magic, ObjectInput in, UnmarshalledReferences refMap) throws IOException, ClassNotFoundException {
        Object v = this.unmarshallObject(in, refMap);
        switch (magic) {
            case 30: {
                return InternalEntryFactory.createValue(v);
            }
            case 31: {
                return InternalEntryFactory.createValue(v, this.readUnsignedLong(in), (Long)this.unmarshallObject(in, refMap), -1L, -1L);
            }
            case 32: {
                return InternalEntryFactory.createValue(v, -1L, -1L, this.readUnsignedLong(in), (Long)this.unmarshallObject(in, refMap));
            }
            case 33: {
                return InternalEntryFactory.createValue(v, this.readUnsignedLong(in), (Long)this.unmarshallObject(in, refMap), this.readUnsignedLong(in), (Long)this.unmarshallObject(in, refMap));
            }
        }
        throw new IllegalArgumentException("Unknown magic number " + magic);
    }

    private FastCopyHashMap unmarshallFastCopyHashMap(ObjectInput in, UnmarshalledReferences refMap) throws IOException, ClassNotFoundException {
        FastCopyHashMap map = new FastCopyHashMap();
        this.populateFromStream(in, refMap, map);
        return map;
    }

    protected String unmarshallString(ObjectInput in) throws IOException, ClassNotFoundException {
        return (String)in.readObject();
    }

    private ReplicableCommand unmarshallCommand(ObjectInput in, UnmarshalledReferences refMap) throws IOException, ClassNotFoundException {
        short methodId = in.readShort();
        int numArgs = in.readByte();
        Object[] args = null;
        if (numArgs > 0) {
            args = new Object[numArgs];
            for (int i = 0; i < numArgs; ++i) {
                args[i] = this.unmarshallObject(in, refMap);
            }
        }
        return this.remoteCommandFactory.fromStream((byte)methodId, args);
    }

    private GlobalTransaction unmarshallGlobalTransaction(ObjectInput in, UnmarshalledReferences refMap) throws IOException, ClassNotFoundException {
        GlobalTransaction gtx = new GlobalTransaction();
        long id = in.readLong();
        Object address = this.unmarshallObject(in, refMap);
        gtx.setId(id);
        gtx.setAddress((Address)address);
        return gtx;
    }

    private JGroupsAddress unmarshallJGroupsAddress(ObjectInput in) throws IOException, ClassNotFoundException {
        org.jgroups.Address jga = (org.jgroups.Address)in.readObject();
        return new JGroupsAddress(jga);
    }

    private List unmarshallArrayList(ObjectInput in, UnmarshalledReferences refMap) throws IOException, ClassNotFoundException {
        int listSize = this.readUnsignedInt(in);
        ArrayList list = new ArrayList(listSize);
        this.populateFromStream(in, refMap, list, listSize);
        return list;
    }

    private List unmarshallLinkedList(ObjectInput in, UnmarshalledReferences refMap) throws IOException, ClassNotFoundException {
        LinkedList list = new LinkedList();
        this.populateFromStream(in, refMap, list, this.readUnsignedInt(in));
        return list;
    }

    private List unmarshallSingletonList(ObjectInput in, UnmarshalledReferences refMap) throws IOException, ClassNotFoundException {
        return Collections.singletonList(this.unmarshallObject(in, refMap));
    }

    private Map unmarshallHashMap(ObjectInput in, UnmarshalledReferences refMap) throws IOException, ClassNotFoundException {
        HashMap map = new HashMap();
        this.populateFromStream(in, refMap, map);
        return map;
    }

    private Map unmarshallMapCopy(ObjectInput in, UnmarshalledReferences refMap) throws IOException, ClassNotFoundException {
        Map m = this.unmarshallHashMap(in, refMap);
        return Immutables.immutableMapWrap(m);
    }

    private Map unmarshallTreeMap(ObjectInput in, UnmarshalledReferences refMap) throws IOException, ClassNotFoundException {
        TreeMap map = new TreeMap();
        this.populateFromStream(in, refMap, map);
        return map;
    }

    private Set unmarshallHashSet(ObjectInput in, UnmarshalledReferences refMap) throws IOException, ClassNotFoundException {
        HashSet set = new HashSet();
        this.populateFromStream(in, refMap, set);
        return set;
    }

    private Set unmarshallTreeSet(ObjectInput in, UnmarshalledReferences refMap) throws IOException, ClassNotFoundException {
        TreeSet set = new TreeSet();
        this.populateFromStream(in, refMap, set);
        return set;
    }

    private void populateFromStream(ObjectInput in, UnmarshalledReferences refMap, Map mapToPopulate) throws IOException, ClassNotFoundException {
        int size = this.readUnsignedInt(in);
        for (int i = 0; i < size; ++i) {
            mapToPopulate.put(this.unmarshallObject(in, refMap), this.unmarshallObject(in, refMap));
        }
    }

    private void populateFromStream(ObjectInput in, UnmarshalledReferences refMap, Set setToPopulate) throws IOException, ClassNotFoundException {
        int size = this.readUnsignedInt(in);
        for (int i = 0; i < size; ++i) {
            setToPopulate.add(this.unmarshallObject(in, refMap));
        }
    }

    private void populateFromStream(ObjectInput in, UnmarshalledReferences refMap, List listToPopulate, int listSize) throws IOException, ClassNotFoundException {
        for (int i = 0; i < listSize; ++i) {
            listToPopulate.add(this.unmarshallObject(in, refMap));
        }
    }

    protected void writeReference(ObjectOutput out, int reference) throws IOException {
        this.writeUnsignedInt(out, reference);
    }

    protected int readReference(ObjectInput in) throws IOException {
        return this.readUnsignedInt(in);
    }

    protected Object unmarshallArray(ObjectInput in, UnmarshalledReferences refs) throws IOException, ClassNotFoundException {
        int sz = this.readUnsignedInt(in);
        byte type = in.readByte();
        switch (type) {
            case 6: {
                boolean isPrim = in.readBoolean();
                if (isPrim) {
                    boolean[] a = new boolean[sz];
                    for (int i = 0; i < sz; ++i) {
                        a[i] = in.readBoolean();
                    }
                    return a;
                }
                Boolean[] a = new Boolean[sz];
                for (int i = 0; i < sz; ++i) {
                    a[i] = in.readBoolean();
                }
                return a;
            }
            case 4: {
                boolean isPrim = in.readBoolean();
                if (isPrim) {
                    int[] a = new int[sz];
                    for (int i = 0; i < sz; ++i) {
                        a[i] = in.readInt();
                    }
                    return a;
                }
                Integer[] a = new Integer[sz];
                for (int i = 0; i < sz; ++i) {
                    a[i] = in.readInt();
                }
                return a;
            }
            case 5: {
                boolean isPrim = in.readBoolean();
                if (isPrim) {
                    long[] a = new long[sz];
                    for (int i = 0; i < sz; ++i) {
                        a[i] = in.readLong();
                    }
                    return a;
                }
                Long[] a = new Long[sz];
                for (int i = 0; i < sz; ++i) {
                    a[i] = in.readLong();
                }
                return a;
            }
            case 19: {
                boolean isPrim = in.readBoolean();
                if (isPrim) {
                    char[] a = new char[sz];
                    for (int i = 0; i < sz; ++i) {
                        a[i] = in.readChar();
                    }
                    return a;
                }
                Character[] a = new Character[sz];
                for (int i = 0; i < sz; ++i) {
                    a[i] = Character.valueOf(in.readChar());
                }
                return a;
            }
            case 18: {
                boolean isPrim = in.readBoolean();
                if (isPrim) {
                    int read;
                    byte[] a = new byte[sz];
                    int bsize = 10240;
                    int offset = 0;
                    for (int bytesLeft = sz; bytesLeft > 0; bytesLeft -= read) {
                        read = in.read(a, offset, Math.min(bsize, bytesLeft));
                        offset += read;
                    }
                    return a;
                }
                Byte[] a = new Byte[sz];
                for (int i = 0; i < sz; ++i) {
                    a[i] = in.readByte();
                }
                return a;
            }
            case 13: {
                boolean isPrim = in.readBoolean();
                if (isPrim) {
                    short[] a = new short[sz];
                    for (int i = 0; i < sz; ++i) {
                        a[i] = in.readShort();
                    }
                    return a;
                }
                Short[] a = new Short[sz];
                for (int i = 0; i < sz; ++i) {
                    a[i] = in.readShort();
                }
                return a;
            }
            case 20: {
                boolean isPrim = in.readBoolean();
                if (isPrim) {
                    float[] a = new float[sz];
                    for (int i = 0; i < sz; ++i) {
                        a[i] = in.readFloat();
                    }
                    return a;
                }
                Float[] a = new Float[sz];
                for (int i = 0; i < sz; ++i) {
                    a[i] = Float.valueOf(in.readFloat());
                }
                return a;
            }
            case 21: {
                boolean isPrim = in.readBoolean();
                if (isPrim) {
                    double[] a = new double[sz];
                    for (int i = 0; i < sz; ++i) {
                        a[i] = in.readDouble();
                    }
                    return a;
                }
                Double[] a = new Double[sz];
                for (int i = 0; i < sz; ++i) {
                    a[i] = in.readDouble();
                }
                return a;
            }
            case 22: {
                Object[] a = new Object[sz];
                for (int i = 0; i < sz; ++i) {
                    a[i] = this.unmarshallObject(in, refs);
                }
                return a;
            }
        }
        throw new CacheException("Unknown array type");
    }

    protected void marshallArray(Object o, ObjectOutput out, Map<Object, Integer> refMap) throws IOException {
        out.writeByte(17);
        Class<?> arrayTypeClass = o.getClass().getComponentType();
        int sz = Array.getLength(o);
        this.writeUnsignedInt(out, sz);
        boolean isPrim = arrayTypeClass.isPrimitive();
        if (!isPrim && arrayTypeClass.equals(Object.class)) {
            out.writeByte(22);
            for (int i = 0; i < sz; ++i) {
                this.marshallObject(Array.get(o, i), out, refMap);
            }
        } else if (arrayTypeClass.equals(Byte.TYPE) || arrayTypeClass.equals(Byte.class)) {
            out.writeByte(18);
            out.writeBoolean(isPrim);
            if (isPrim) {
                out.write((byte[])o);
            } else {
                for (int i = 0; i < sz; ++i) {
                    out.writeByte(((Byte)Array.get(o, i)).byteValue());
                }
            }
        } else if (arrayTypeClass.equals(Integer.TYPE) || arrayTypeClass.equals(Integer.class)) {
            out.writeByte(4);
            out.writeBoolean(isPrim);
            if (isPrim) {
                for (int i = 0; i < sz; ++i) {
                    out.writeInt(Array.getInt(o, i));
                }
            } else {
                for (int i = 0; i < sz; ++i) {
                    out.writeInt((Integer)Array.get(o, i));
                }
            }
        } else if (arrayTypeClass.equals(Long.TYPE) || arrayTypeClass.equals(Long.class)) {
            out.writeByte(5);
            out.writeBoolean(isPrim);
            if (isPrim) {
                for (int i = 0; i < sz; ++i) {
                    out.writeLong(Array.getLong(o, i));
                }
            } else {
                for (int i = 0; i < sz; ++i) {
                    out.writeLong((Long)Array.get(o, i));
                }
            }
        } else if (arrayTypeClass.equals(Boolean.TYPE) || arrayTypeClass.equals(Boolean.class)) {
            out.writeByte(6);
            out.writeBoolean(isPrim);
            if (isPrim) {
                for (int i = 0; i < sz; ++i) {
                    out.writeBoolean(Array.getBoolean(o, i));
                }
            } else {
                for (int i = 0; i < sz; ++i) {
                    out.writeBoolean((Boolean)Array.get(o, i));
                }
            }
        } else if (arrayTypeClass.equals(Character.TYPE) || arrayTypeClass.equals(Character.class)) {
            out.writeByte(19);
            out.writeBoolean(isPrim);
            if (isPrim) {
                for (int i = 0; i < sz; ++i) {
                    out.writeChar(Array.getChar(o, i));
                }
            } else {
                for (int i = 0; i < sz; ++i) {
                    out.writeChar(((Character)Array.get(o, i)).charValue());
                }
            }
        } else if (arrayTypeClass.equals(Short.TYPE) || arrayTypeClass.equals(Short.class)) {
            out.writeByte(13);
            out.writeBoolean(isPrim);
            if (isPrim) {
                for (int i = 0; i < sz; ++i) {
                    out.writeShort(Array.getShort(o, i));
                }
            } else {
                for (int i = 0; i < sz; ++i) {
                    out.writeShort(((Short)Array.get(o, i)).shortValue());
                }
            }
        } else if (arrayTypeClass.equals(Float.TYPE) || arrayTypeClass.equals(Float.class)) {
            out.writeByte(20);
            out.writeBoolean(isPrim);
            if (isPrim) {
                for (int i = 0; i < sz; ++i) {
                    out.writeFloat(Array.getFloat(o, i));
                }
            } else {
                for (int i = 0; i < sz; ++i) {
                    out.writeFloat(((Float)Array.get(o, i)).floatValue());
                }
            }
        } else if (arrayTypeClass.equals(Double.TYPE) || arrayTypeClass.equals(Double.class)) {
            out.writeByte(21);
            out.writeBoolean(isPrim);
            if (isPrim) {
                for (int i = 0; i < sz; ++i) {
                    out.writeDouble(Array.getDouble(o, i));
                }
            } else {
                for (int i = 0; i < sz; ++i) {
                    out.writeDouble((Double)Array.get(o, i));
                }
            }
        } else {
            throw new CacheException("Unknown array type!");
        }
    }

    protected boolean isKnownType(Class c) {
        return c.equals(Object.class) || c.isPrimitive() || c.equals(Character.class) || c.equals(Integer.class) || c.equals(Long.class) || c.equals(Byte.class) || c.equals(Boolean.class) || c.equals(Short.class) || c.equals(Float.class) || c.equals(Double.class);
    }

    @Override
    public ObjectOutput startObjectOutput(OutputStream os, boolean isReentrant) throws IOException {
        return new ObjectOutputStream(os);
    }

    @Override
    public void finishObjectOutput(ObjectOutput oo) {
        Util.flushAndCloseOutput(oo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void objectToObjectStream(Object o, ObjectOutput out) throws IOException {
        IdentityHashMap<Object, Integer> refMap = this.useRefs ? new IdentityHashMap<Object, Integer>() : null;
        ClassLoader toUse = this.defaultClassLoader;
        Thread current = Thread.currentThread();
        ClassLoader old = current.getContextClassLoader();
        if (old != null) {
            toUse = old;
        }
        try {
            current.setContextClassLoader(toUse);
            this.marshallObject(o, out, refMap);
        }
        finally {
            current.setContextClassLoader(old);
        }
    }

    @Override
    public ObjectInput startObjectInput(InputStream is, boolean isReentrant) throws IOException {
        return new ObjectInputStream(is);
    }

    @Override
    public void finishObjectInput(ObjectInput oi) {
        Util.closeInput(oi);
    }

    @Override
    public Object objectFromObjectStream(ObjectInput in) throws IOException, ClassNotFoundException {
        UnmarshalledReferences refMap = this.useRefs ? new UnmarshalledReferences() : null;
        Object retValue = this.unmarshallObject(in, this.defaultClassLoader, refMap, false);
        if (this.trace) {
            this.log.trace("Unmarshalled object " + retValue);
        }
        return retValue;
    }

    @Override
    public ByteBuffer objectToBuffer(Object o) throws IOException {
        ExposedByteArrayOutputStream baos = new ExposedByteArrayOutputStream(128);
        ObjectOutputStream out = new ObjectOutputStream(baos);
        this.objectToObjectStream(o, out);
        out.close();
        return new ByteBuffer(baos.getRawBuffer(), 0, baos.size());
    }

    @Override
    public Object objectFromByteBuffer(byte[] buf, int offset, int length) throws IOException, ClassNotFoundException {
        MarshalledValueInputStream in = new MarshalledValueInputStream((InputStream)new ByteArrayInputStream(buf, offset, length));
        return this.objectFromObjectStream((ObjectInput)in);
    }

    @Override
    public Object objectFromByteBuffer(byte[] bytes) throws IOException, ClassNotFoundException {
        return this.objectFromByteBuffer(bytes, 0, bytes.length);
    }

    private int readUnsignedInt(ObjectInput in) throws IOException {
        return UnsignedNumeric.readUnsignedInt(in);
    }

    private long readUnsignedLong(ObjectInput in) throws IOException {
        return UnsignedNumeric.readUnsignedLong(in);
    }

    private void writeUnsignedInt(ObjectOutput o, int i) throws IOException {
        UnsignedNumeric.writeUnsignedInt(o, i);
    }

    private void writeUnsignedLong(ObjectOutput o, long i) throws IOException {
        UnsignedNumeric.writeUnsignedLong(o, i);
    }
}

