/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.loaders.file;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.HashSet;
import java.util.Set;
import org.infinispan.Cache;
import org.infinispan.config.ConfigurationException;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.loaders.CacheLoaderConfig;
import org.infinispan.loaders.CacheLoaderException;
import org.infinispan.loaders.bucket.Bucket;
import org.infinispan.loaders.bucket.BucketBasedCacheStore;
import org.infinispan.loaders.file.FileCacheStoreConfig;
import org.infinispan.marshall.Marshaller;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileCacheStore
extends BucketBasedCacheStore {
    private static final Log log = LogFactory.getLog(FileCacheStore.class);
    private int streamBufferSize;
    FileCacheStoreConfig config;
    Cache cache;
    File root;

    public File getRoot() {
        return this.root;
    }

    @Override
    public void init(CacheLoaderConfig config, Cache cache, Marshaller m) {
        super.init(config, cache, m);
        this.config = (FileCacheStoreConfig)config;
        this.cache = cache;
    }

    @Override
    protected Set<InternalCacheEntry> loadAllLockSafe() throws CacheLoaderException {
        HashSet<InternalCacheEntry> result = new HashSet<InternalCacheEntry>();
        for (File bucketFile : this.root.listFiles()) {
            Bucket bucket = this.loadBucket(bucketFile);
            if (bucket == null) continue;
            if (bucket.removeExpiredEntries()) {
                this.saveBucket(bucket);
            }
            result.addAll(bucket.getStoredEntries());
        }
        return result;
    }

    @Override
    protected void fromStreamLockSafe(ObjectInput objectInput) throws CacheLoaderException {
        try {
            int numFiles = objectInput.readInt();
            byte[] buffer = new byte[this.streamBufferSize];
            int totalBytesRead = 0;
            for (int i = 0; i < numFiles; ++i) {
                int bytesRead;
                String fName = (String)objectInput.readObject();
                int numBytes = objectInput.readInt();
                FileOutputStream fos = new FileOutputStream(this.root.getAbsolutePath() + File.separator + fName);
                BufferedOutputStream bos = new BufferedOutputStream(fos, this.streamBufferSize);
                while (numBytes > totalBytesRead && (bytesRead = objectInput.read(buffer, 0, this.streamBufferSize)) != -1) {
                    totalBytesRead += bytesRead;
                    bos.write(buffer, 0, bytesRead);
                }
                bos.flush();
                this.safeClose(bos);
                fos.flush();
                this.safeClose(fos);
                totalBytesRead = 0;
            }
        }
        catch (IOException e) {
            throw new CacheLoaderException("I/O error", e);
        }
        catch (ClassNotFoundException e) {
            throw new CacheLoaderException("Unexpected expcetion", e);
        }
    }

    @Override
    protected void toStreamLockSafe(ObjectOutput objectOutput) throws CacheLoaderException {
        try {
            File[] files = this.root.listFiles();
            objectOutput.writeInt(files.length);
            byte[] buffer = new byte[this.streamBufferSize];
            for (File file : files) {
                int bytesRead;
                FileInputStream fileInStream = new FileInputStream(file);
                int sz = fileInStream.available();
                BufferedInputStream bis = new BufferedInputStream(fileInStream);
                objectOutput.writeObject(file.getName());
                objectOutput.writeInt(sz);
                for (int totalBytesRead = 0; sz > totalBytesRead && (bytesRead = bis.read(buffer, 0, this.streamBufferSize)) != -1; totalBytesRead += bytesRead) {
                    objectOutput.write(buffer, 0, bytesRead);
                }
                bis.close();
                fileInStream.close();
            }
        }
        catch (IOException e) {
            throw new CacheLoaderException("I/O expcetion while generating stream", e);
        }
    }

    @Override
    protected void clearLockSafe() throws CacheLoaderException {
        File[] toDelete = this.root.listFiles();
        if (toDelete == null) {
            return;
        }
        for (File f : toDelete) {
            f.delete();
            if (!f.exists()) continue;
            log.warn((Object)"Had problems removing file {0}", f);
        }
    }

    @Override
    protected void purgeInternal() throws CacheLoaderException {
        this.loadAll();
    }

    @Override
    protected Bucket loadBucket(String bucketName) throws CacheLoaderException {
        return this.loadBucket(new File(this.root, bucketName));
    }

    protected Bucket loadBucket(File bucketFile) throws CacheLoaderException {
        Bucket bucket = null;
        if (bucketFile.exists()) {
            if (log.isTraceEnabled()) {
                log.trace("Found bucket file: '" + bucketFile + "'");
            }
            FileInputStream is = null;
            try {
                is = new FileInputStream(bucketFile);
                bucket = (Bucket)this.marshaller.objectFromInputStream(is);
            }
            catch (Exception e) {
                String message = "Error while reading from file: " + bucketFile.getAbsoluteFile();
                log.error((Object)message, e);
                throw new CacheLoaderException(message, e);
            }
            finally {
                this.safeClose(is);
            }
        }
        if (bucket != null) {
            bucket.setBucketName(bucketFile.getName());
        }
        return bucket;
    }

    @Override
    protected void insertBucket(Bucket bucket) throws CacheLoaderException {
        this.saveBucket(bucket);
    }

    @Override
    public void saveBucket(Bucket b) throws CacheLoaderException {
        File f = new File(this.root, b.getBucketName());
        if (f.exists()) {
            if (!f.delete()) {
                log.warn((Object)"Had problems removing file {0}", f);
            }
        } else if (log.isTraceEnabled()) {
            log.trace("Successfully deleted file: '" + f.getName() + "'");
        }
        if (!b.getEntries().isEmpty()) {
            FileOutputStream fos = null;
            try {
                byte[] bytes = this.marshaller.objectToByteBuffer(b);
                fos = new FileOutputStream(f);
                fos.write(bytes);
                fos.flush();
            }
            catch (IOException ex) {
                try {
                    log.error((Object)("Exception while saving bucket " + b), ex);
                    throw new CacheLoaderException(ex);
                }
                catch (Throwable throwable) {
                    this.safeClose(fos);
                    throw throwable;
                }
            }
            this.safeClose(fos);
        }
    }

    @Override
    public Class<? extends CacheLoaderConfig> getConfigurationClass() {
        return FileCacheStoreConfig.class;
    }

    @Override
    public void start() throws CacheLoaderException {
        super.start();
        String location = this.config.getLocation();
        if (location == null || location.trim().length() == 0) {
            location = "Infinispan-FileCacheStore";
        }
        location = location + File.separator + this.cache.getName();
        this.root = new File(location);
        this.root.mkdirs();
        if (!this.root.exists()) {
            throw new ConfigurationException("Directory " + this.root.getAbsolutePath() + " does not exist and cannot be created!");
        }
        this.streamBufferSize = this.config.getStreamBufferSize();
    }

    public Bucket loadBucketContainingKey(String key) throws CacheLoaderException {
        return this.loadBucket(key.hashCode() + "");
    }
}

