/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.interceptors;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import org.infinispan.commands.LockControlCommand;
import org.infinispan.commands.read.GetKeyValueCommand;
import org.infinispan.commands.tx.CommitCommand;
import org.infinispan.commands.tx.PrepareCommand;
import org.infinispan.commands.tx.RollbackCommand;
import org.infinispan.commands.write.ClearCommand;
import org.infinispan.commands.write.EvictCommand;
import org.infinispan.commands.write.InvalidateCommand;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.commands.write.PutMapCommand;
import org.infinispan.commands.write.RemoveCommand;
import org.infinispan.commands.write.ReplaceCommand;
import org.infinispan.container.DataContainer;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.context.Flag;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.impl.TxInvocationContext;
import org.infinispan.factories.EntryFactory;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.interceptors.base.CommandInterceptor;
import org.infinispan.transaction.xa.GlobalTransaction;
import org.infinispan.util.BidirectionalMap;
import org.infinispan.util.ReversibleOrderedSet;
import org.infinispan.util.concurrent.IsolationLevel;
import org.infinispan.util.concurrent.locks.LockManager;

public class LockingInterceptor
extends CommandInterceptor {
    LockManager lockManager;
    DataContainer dataContainer;
    EntryFactory entryFactory;
    boolean useReadCommitted;

    @Inject
    public void setDependencies(LockManager lockManager, DataContainer dataContainer, EntryFactory entryFactory) {
        this.lockManager = lockManager;
        this.dataContainer = dataContainer;
        this.entryFactory = entryFactory;
    }

    @Start
    private void determineIsolationLevel() {
        this.useReadCommitted = this.configuration.getIsolationLevel() == IsolationLevel.READ_COMMITTED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object visitCommitCommand(TxInvocationContext ctx, CommitCommand command) throws Throwable {
        try {
            Object object = this.invokeNextInterceptor(ctx, command);
            return object;
        }
        finally {
            if (!ctx.isInTxScope()) {
                throw new IllegalStateException("Attempting to do a commit or rollback but there is no transactional context in scope. " + ctx);
            }
            this.cleanupLocks(ctx, ctx.getLockOwner(), true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object visitRollbackCommand(TxInvocationContext ctx, RollbackCommand command) throws Throwable {
        try {
            Object object = this.invokeNextInterceptor(ctx, command);
            return object;
        }
        finally {
            if (!ctx.isInTxScope()) {
                throw new IllegalStateException("Attempting to do a commit or rollback but there is no transactional context in scope. " + ctx);
            }
            this.cleanupLocks(ctx, ctx.getLockOwner(), false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object visitPrepareCommand(TxInvocationContext ctx, PrepareCommand command) throws Throwable {
        try {
            Object object = this.invokeNextInterceptor(ctx, command);
            return object;
        }
        finally {
            if (command.isOnePhaseCommit()) {
                this.cleanupLocks(ctx, ctx.getLockOwner(), true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object visitGetKeyValueCommand(InvocationContext ctx, GetKeyValueCommand command) throws Throwable {
        try {
            this.entryFactory.wrapEntryForReading(ctx, command.getKey());
            Object object = this.invokeNextInterceptor(ctx, command);
            return object;
        }
        finally {
            this.doAfterCall(ctx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object visitLockControlCommand(TxInvocationContext ctx, LockControlCommand c) throws Throwable {
        boolean localTxScope = ctx.isOriginLocal() && ctx.isInTxScope();
        boolean shouldInvokeOnCluster = false;
        try {
            Object object;
            if (localTxScope) {
                c.attachGlobalTransaction((GlobalTransaction)ctx.getLockOwner());
            }
            for (Object key : c.getKeys()) {
                if (c.isImplicit() && localTxScope && !this.lockManager.ownsLock(key, ctx.getLockOwner())) {
                    shouldInvokeOnCluster = true;
                }
                this.entryFactory.wrapEntryForWriting(ctx, key, true, false, false, false);
            }
            if (shouldInvokeOnCluster || c.isExplicit()) {
                object = this.invokeNextInterceptor(ctx, c);
                return object;
            }
            object = null;
            return object;
        }
        finally {
            if (!ctx.isInTxScope()) {
                throw new IllegalStateException("Attempting to lock but there is no transactional context in scope. " + ctx);
            }
            this.doAfterCall(ctx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object visitClearCommand(InvocationContext ctx, ClearCommand command) throws Throwable {
        try {
            for (Object key : this.dataContainer.keySet()) {
                this.entryFactory.wrapEntryForWriting(ctx, key, false, false, false, false);
            }
            Object object = this.invokeNextInterceptor(ctx, command);
            return object;
        }
        finally {
            this.doAfterCall(ctx);
        }
    }

    public Object visitEvictCommand(InvocationContext ctx, EvictCommand command) throws Throwable {
        ctx.setFlags(Flag.ZERO_LOCK_ACQUISITION_TIMEOUT);
        return this.visitRemoveCommand(ctx, command);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object visitInvalidateCommand(InvocationContext ctx, InvalidateCommand command) throws Throwable {
        try {
            if (command.getKeys() != null) {
                for (Object key : command.getKeys()) {
                    this.entryFactory.wrapEntryForWriting(ctx, key, false, true, false, false);
                }
            }
            Object object = this.invokeNextInterceptor(ctx, command);
            return object;
        }
        finally {
            this.doAfterCall(ctx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object visitPutKeyValueCommand(InvocationContext ctx, PutKeyValueCommand command) throws Throwable {
        try {
            this.entryFactory.wrapEntryForWriting(ctx, command.getKey(), true, false, false, false);
            Object object = this.invokeNextInterceptor(ctx, command);
            return object;
        }
        finally {
            this.doAfterCall(ctx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object visitPutMapCommand(InvocationContext ctx, PutMapCommand command) throws Throwable {
        try {
            for (Object key : command.getMap().keySet()) {
                this.entryFactory.wrapEntryForWriting(ctx, key, true, false, false, false);
            }
            Object object = this.invokeNextInterceptor(ctx, command);
            return object;
        }
        finally {
            this.doAfterCall(ctx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object visitRemoveCommand(InvocationContext ctx, RemoveCommand command) throws Throwable {
        try {
            this.entryFactory.wrapEntryForWriting(ctx, command.getKey(), false, true, false, true);
            Object object = this.invokeNextInterceptor(ctx, command);
            return object;
        }
        finally {
            this.doAfterCall(ctx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object visitReplaceCommand(InvocationContext ctx, ReplaceCommand command) throws Throwable {
        try {
            this.entryFactory.wrapEntryForWriting(ctx, command.getKey(), false, true, false, false);
            Object object = this.invokeNextInterceptor(ctx, command);
            return object;
        }
        finally {
            this.doAfterCall(ctx);
        }
    }

    private void doAfterCall(InvocationContext ctx) {
        if (!ctx.isInTxScope()) {
            this.cleanupLocks(ctx, ctx.getLockOwner(), true);
        } else {
            BidirectionalMap<Object, CacheEntry> lookedUpEntries;
            if (this.trace) {
                this.log.trace("Transactional.  Not cleaning up locks till the transaction ends.");
            }
            if (this.useReadCommitted && (lookedUpEntries = ctx.getLookedUpEntries()) != null && !lookedUpEntries.isEmpty()) {
                ArrayList keysToRemove = new ArrayList(lookedUpEntries.size());
                for (Map.Entry e : lookedUpEntries.entrySet()) {
                    if (this.lockManager.possiblyLocked((CacheEntry)e.getValue())) continue;
                    keysToRemove.add(e.getKey());
                }
                if (!keysToRemove.isEmpty()) {
                    if (this.trace) {
                        this.log.trace((Object)"Removing keys {0} since they have not been modified.  Context currently contains {1} keys", keysToRemove, ctx.getLookedUpEntries().size());
                    }
                    for (Map.Entry key : keysToRemove) {
                        ctx.removeLookedUpEntry(key);
                    }
                    if (this.trace) {
                        this.log.trace((Object)"After removal, context contains {0} keys", ctx.getLookedUpEntries().size());
                    }
                }
            }
        }
    }

    private void cleanupLocks(InvocationContext ctx, Object owner, boolean commit) {
        ReversibleOrderedSet<Map.Entry<Object, CacheEntry>> entries = ctx.getLookedUpEntries().entrySet();
        Iterator<Map.Entry<Object, CacheEntry>> it = entries.reverseIterator();
        if (this.trace) {
            this.log.trace((Object)"Number of entries in context: {0}", entries.size());
        }
        if (commit) {
            while (it.hasNext()) {
                Map.Entry<Object, CacheEntry> e = it.next();
                CacheEntry entry = e.getValue();
                Object key = e.getKey();
                boolean needToUnlock = this.lockManager.possiblyLocked(entry);
                if (entry != null && entry.isChanged()) {
                    this.commitEntry(ctx, entry);
                } else if (this.trace) {
                    this.log.trace((Object)"Entry for key {0} is null, not calling commitUpdate", key);
                }
                if (!needToUnlock) continue;
                if (this.trace) {
                    this.log.trace("Releasing lock on [" + key + "] for owner " + owner);
                }
                this.lockManager.unlock(key, owner);
            }
        } else {
            while (it.hasNext()) {
                Map.Entry<Object, CacheEntry> e = it.next();
                CacheEntry entry = e.getValue();
                Object key = e.getKey();
                boolean needToUnlock = this.lockManager.possiblyLocked(entry);
                if (entry != null && entry.isChanged()) {
                    entry.rollback();
                } else if (this.trace) {
                    this.log.trace((Object)"Entry for key {0} is null, not calling rollbackUpdate", key);
                }
                if (!needToUnlock) continue;
                if (this.trace) {
                    this.log.trace("Releasing lock on [" + key + "] for owner " + owner);
                }
                this.lockManager.unlock(key, owner);
            }
        }
    }

    protected void commitEntry(InvocationContext ctx, CacheEntry entry) {
        entry.commit(this.dataContainer);
    }
}

