/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.interceptors;

import java.util.concurrent.atomic.AtomicLong;
import org.infinispan.commands.read.GetKeyValueCommand;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.commands.write.PutMapCommand;
import org.infinispan.commands.write.RemoveCommand;
import org.infinispan.commands.write.ReplaceCommand;
import org.infinispan.config.ConfigurationException;
import org.infinispan.context.InvocationContext;
import org.infinispan.factories.annotations.Start;
import org.infinispan.interceptors.CacheLoaderInterceptor;
import org.infinispan.jmx.annotations.MBean;
import org.infinispan.jmx.annotations.ManagedAttribute;
import org.infinispan.jmx.annotations.ManagedOperation;
import org.infinispan.loaders.CacheLoaderException;
import org.infinispan.loaders.CacheStore;

@MBean(objectName="Activation", description="Component that handles activating entries that have been passivated to a CacheStore by loading them into memory.")
public class ActivationInterceptor
extends CacheLoaderInterceptor {
    private AtomicLong activations = new AtomicLong(0L);
    private CacheStore store;

    @Start(priority=15)
    public void setCacheStore() {
        CacheStore cacheStore = this.store = this.clm == null ? null : this.clm.getCacheStore();
        if (this.store == null) {
            throw new ConfigurationException("passivation can only be used with a CacheLoader that implements CacheStore!");
        }
    }

    public Object visitPutKeyValueCommand(InvocationContext ctx, PutKeyValueCommand command) throws Throwable {
        Object retval = super.visitPutKeyValueCommand(ctx, command);
        this.removeFromStore(command.getKey());
        return retval;
    }

    public Object visitRemoveCommand(InvocationContext ctx, RemoveCommand command) throws Throwable {
        Object retval = super.visitRemoveCommand(ctx, command);
        this.removeFromStore(command.getKey());
        return retval;
    }

    public Object visitReplaceCommand(InvocationContext ctx, ReplaceCommand command) throws Throwable {
        Object retval = super.visitReplaceCommand(ctx, command);
        this.removeFromStore(command.getKey());
        return retval;
    }

    public Object visitPutMapCommand(InvocationContext ctx, PutMapCommand command) throws Throwable {
        Object retval = super.visitPutMapCommand(ctx, command);
        this.removeFromStore(command.getMap().keySet().toArray());
        return retval;
    }

    public Object visitGetKeyValueCommand(InvocationContext ctx, GetKeyValueCommand command) throws Throwable {
        Object retval = super.visitGetKeyValueCommand(ctx, command);
        this.removeFromStore(command.getKey());
        return retval;
    }

    private void removeFromStore(Object ... keys) throws CacheLoaderException {
        for (Object k : keys) {
            if (!this.store.remove(k) || !this.getStatisticsEnabled()) continue;
            this.activations.incrementAndGet();
        }
    }

    protected void sendNotification(Object key, boolean pre, InvocationContext ctx) {
        super.sendNotification(key, pre, ctx);
        this.notifier.notifyCacheEntryActivated(key, pre, ctx);
    }

    @ManagedAttribute(description="Number of activation events")
    public String getActivations() {
        if (!this.getStatisticsEnabled()) {
            return "N/A";
        }
        return String.valueOf(this.activations.get());
    }

    @ManagedOperation(description="Resets statistics gathered by this component")
    public void resetStatistics() {
        super.resetStatistics();
        this.activations.set(0L);
    }
}

