/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.distribution;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.infinispan.distribution.ConsistentHash;
import org.infinispan.remoting.transport.Address;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultConsistentHash
implements ConsistentHash {
    volatile ArrayList<Address> addresses;

    @Override
    public void setCaches(Collection<Address> caches) {
        this.addresses = new ArrayList<Address>(caches);
        this.addresses.trimToSize();
    }

    @Override
    public List<Address> locate(Object key, int replicationCount) {
        int hash = Math.abs(key.hashCode());
        int clusterSize = this.addresses.size();
        int numCopiesToFind = Math.min(replicationCount, clusterSize);
        ArrayList<Address> results = new ArrayList<Address>(numCopiesToFind);
        int copyNumber = 0;
        while (results.size() < numCopiesToFind) {
            int index = (hash % clusterSize + copyNumber) % clusterSize;
            Address candidate = this.addresses.get(index);
            results.add(candidate);
            ++copyNumber;
        }
        return results;
    }

    @Override
    public Map<Object, List<Address>> locateAll(Collection<Object> keys, int replCount) {
        HashMap<Object, List<Address>> locations = new HashMap<Object, List<Address>>();
        for (Object k : keys) {
            locations.put(k, this.locate(k, replCount));
        }
        return locations;
    }
}

