/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.container.entries;

import org.infinispan.container.entries.ExpiryHelper;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.container.entries.MortalCacheValue;
import org.infinispan.container.entries.TransientMortalCacheEntry;

public class TransientMortalCacheValue
extends MortalCacheValue {
    long maxIdle = -1L;
    long lastUsed;

    TransientMortalCacheValue(Object value, long created, long lifespan, long maxIdle, long lastUsed) {
        this(value, created, lifespan, maxIdle);
        this.lastUsed = lastUsed;
    }

    public TransientMortalCacheValue(Object value, long created, long lifespan, long maxIdle) {
        super(value, created, lifespan);
        this.maxIdle = maxIdle;
    }

    public TransientMortalCacheValue(Object value, long created) {
        super(value, created, -1L);
    }

    public long getMaxIdle() {
        return this.maxIdle;
    }

    public void setMaxIdle(long maxIdle) {
        this.maxIdle = maxIdle;
    }

    public long getLastUsed() {
        return this.lastUsed;
    }

    public void setLastUsed(long lastUsed) {
        this.lastUsed = lastUsed;
    }

    public boolean isExpired() {
        return ExpiryHelper.isExpiredTransientMortal(this.maxIdle, this.lastUsed, this.lifespan, this.created);
    }

    public InternalCacheEntry toInternalCacheEntry(Object key) {
        return new TransientMortalCacheEntry(key, this.value, this.maxIdle, this.lifespan, this.lastUsed, this.created);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TransientMortalCacheValue)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TransientMortalCacheValue that = (TransientMortalCacheValue)o;
        if (this.lastUsed != that.lastUsed) {
            return false;
        }
        return this.maxIdle == that.maxIdle;
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (int)(this.maxIdle ^ this.maxIdle >>> 32);
        result = 31 * result + (int)(this.lastUsed ^ this.lastUsed >>> 32);
        return result;
    }

    public String toString() {
        return "TransientMortalCacheValue{maxIdle=" + this.maxIdle + ", lastUsed=" + this.lastUsed + "} " + super.toString();
    }

    public TransientMortalCacheValue clone() {
        return (TransientMortalCacheValue)super.clone();
    }
}

