/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.container.entries;

import org.infinispan.container.entries.ExpiryHelper;
import org.infinispan.container.entries.ImmortalCacheValue;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.container.entries.MortalCacheEntry;

public class MortalCacheValue
extends ImmortalCacheValue {
    long created;
    long lifespan = -1L;

    MortalCacheValue(Object value, long created, long lifespan) {
        super(value);
        this.created = created;
        this.lifespan = lifespan;
    }

    public final long getCreated() {
        return this.created;
    }

    public final void setCreated(long created) {
        this.created = created;
    }

    public final long getLifespan() {
        return this.lifespan;
    }

    public final void setLifespan(long lifespan) {
        this.lifespan = lifespan;
    }

    public boolean isExpired() {
        return ExpiryHelper.isExpiredMortal(this.lifespan, this.created);
    }

    public final boolean canExpire() {
        return true;
    }

    public InternalCacheEntry toInternalCacheEntry(Object key) {
        return new MortalCacheEntry(key, this.value, this.lifespan, this.created);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MortalCacheValue)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        MortalCacheValue that = (MortalCacheValue)o;
        if (this.created != that.created) {
            return false;
        }
        return this.lifespan == that.lifespan;
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (int)(this.created ^ this.created >>> 32);
        result = 31 * result + (int)(this.lifespan ^ this.lifespan >>> 32);
        return result;
    }

    public String toString() {
        return "MortalCacheValue{created=" + this.created + ", lifespan=" + this.lifespan + "} " + super.toString();
    }

    public MortalCacheValue clone() {
        return (MortalCacheValue)super.clone();
    }
}

